/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.ui.internal.Workbench;
import org.jetbrains.annotations.NotNull;

public class SWTUtil {
    public static void setCompositeVisiblity(@NotNull Composite composite, boolean visibility) {
        composite.setVisible(visibility);
        Object layoutData = composite.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visibility;
        }
    }

    public static <C extends Control> C findFirstChildOfType(Composite container, Class<C> childClazz) {
        Control[] children;
        Control[] controlArray = children = container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            C child;
            Control control = controlArray[n2];
            if (childClazz.isAssignableFrom(control.getClass())) {
                return (C)control;
            }
            if (control instanceof Composite && (child = SWTUtil.findFirstChildOfType((Composite)control, childClazz)) != null) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public static <C extends Control> C findNextChildOfType(Composite container, Class<C> childClazz, C prev) {
        Control[] children;
        Control[] controlArray = children = container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control != prev) {
                C child;
                if (childClazz.isAssignableFrom(control.getClass())) {
                    return (C)control;
                }
                if (control instanceof Composite && (child = SWTUtil.findNextChildOfType((Composite)control, childClazz, prev)) != null) {
                    return child;
                }
            }
            ++n2;
        }
        return null;
    }

    public static void setFontStyle(Control control, int style) {
        FontData[] fD = control.getFont().getFontData();
        fD[0].setStyle(style);
        Font font = new Font((Device)control.getParent().getDisplay(), fD[0]);
        control.setFont(font);
        control.addDisposeListener(e -> font.dispose());
    }

    public static void setFontSize(Control label, int percent) {
        if (percent < 0) {
            throw new IllegalArgumentException("percent must be => 0");
        }
        FontData[] fD = label.getFont().getFontData();
        fD[0].setHeight(fD[0].getHeight() * percent / 100);
        Font f = new Font((Device)label.getDisplay(), fD[0]);
        label.setFont(f);
        label.addDisposeListener(e -> f.dispose());
    }

    public static void revalidateLayout(Control control) {
        Control c = control;
        do {
            if (!(c instanceof ExpandBar)) continue;
            ExpandBar expandBar = (ExpandBar)c;
            ExpandItem[] expandItemArray = expandBar.getItems();
            int n = expandItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExpandItem expandItem = expandItemArray[n2];
                expandItem.setHeight(expandItem.getControl().computeSize((int)expandBar.getSize().x, (int)-1, (boolean)true).y);
                ++n2;
            }
        } while ((c = c.getParent()) != null && c.getParent() != null && !(c instanceof ScrolledComposite));
        if (c instanceof ScrolledComposite) {
            ScrolledComposite scrolledComposite = (ScrolledComposite)c;
            if (scrolledComposite.getExpandHorizontal() || scrolledComposite.getExpandVertical()) {
                scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1, true));
            } else {
                scrolledComposite.getContent().pack(true);
            }
        }
        if (c instanceof Composite) {
            Composite composite = (Composite)c;
            composite.layout(true, true);
        }
    }

    public static boolean hasDarkBackground(Control control) {
        RGB backgroundColor = control.getBackground().getRGB();
        return SWTUtil.calculateLuminance(backgroundColor) < 128;
    }

    public static boolean isGlobalDarkTheme() {
        try {
            RGB backgroundColor = Workbench.getInstance().getThemeManager().getCurrentTheme().getColorRegistry().getRGB("CONTENT_ASSIST_BACKGROUND_COLOR");
            return SWTUtil.calculateLuminance(backgroundColor) < 128;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int calculateLuminance(RGB rgbColor) {
        return (int)(0.2126 * (double)rgbColor.red + 0.7152 * (double)rgbColor.green + 0.0722 * (double)rgbColor.blue);
    }
}

