/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.remoteservers;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.RemotingContext;
import com.zeroturnaround.jrebel.remoting.util.InfoRequestUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.zeroturnaround.eclipse.ui.remoteservers.RemoteServerSettingsPanel;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class RemoteServerDialog
extends Dialog {
    private RemoteServerConfiguration server;
    private RemoteServerSettingsPanel remoteServerSettingsPanel;
    private static final int TEST_CONNECTION_BUTTON_ID = 5210;

    public RemoteServerDialog(Shell parentShell) {
        this(parentShell, null);
    }

    public RemoteServerDialog(Shell parentShell, RemoteServerConfiguration server) {
        super(parentShell);
        this.server = server;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        GridData contentLayoutData = (GridData)content.getLayoutData();
        contentLayoutData.minimumWidth = 500;
        contentLayoutData.widthHint = 500;
        new BoldLabel(content, this.isNew() ? "Add new server" : "Edit server");
        this.remoteServerSettingsPanel = new RemoteServerSettingsPanel(this.server);
        this.remoteServerSettingsPanel.createContents(content);
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBarWrapper = new Composite(parent, 0);
        buttonBarWrapper.setLayout((Layout)this.stripMargins(new GridLayout(1, false)));
        buttonBarWrapper.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridLayout)buttonBarWrapper.getLayout()).marginLeft = 10;
        this.createButton(buttonBarWrapper, 5210, "Test connection", false);
        Composite nativeButtonBar = new Composite(buttonBarWrapper, 0);
        nativeButtonBar.setLayout((Layout)this.stripMargins(new GridLayout(1, false)));
        nativeButtonBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        return super.createButtonBar(nativeButtonBar);
    }

    private GridLayout stripMargins(GridLayout layout) {
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText("Save");
        this.setButtonLayoutData(ok);
    }

    protected void buttonPressed(int buttonId) {
        RemoteServerConfiguration server;
        super.buttonPressed(buttonId);
        if (5210 == buttonId && (server = this.remoteServerSettingsPanel.getWorkingServerCopy()) != null) {
            this.getButton(5210).setEnabled(false);
            InfoRequestUtil.checkConnection((RemotingContext)IdeRemoting.getInstance(), (RemoteServerConfiguration)this.server, (RemoteServerConfiguration)server, (InfoRequestUtil.Listener)new InfoRequestListener());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.isNew() ? "Add" : "Edit") + " JRebel remote server");
    }

    protected void okPressed() {
        RemoteServerConfiguration saveServer = this.remoteServerSettingsPanel.getResult();
        if (saveServer != null) {
            if (this.isNew()) {
                saveServer.setSyncEnabled(true);
                IdeRemoting.getInstance().getConfigurations().added(saveServer);
            } else {
                IdeRemoting.getInstance().getConfigurations().edited(saveServer);
            }
            super.okPressed();
        }
    }

    private boolean isNew() {
        return this.server == null;
    }

    private class InfoRequestListener
    implements InfoRequestUtil.Listener {
        private InfoRequestListener() {
        }

        public void onResponse(final String message, final boolean isSuccess, final boolean finished) {
            EclipseUtil.runInUiThread(new Runnable(){

                @Override
                public void run() {
                    if (this.canShowMessage()) {
                        if (isSuccess) {
                            RemoteServerDialog.this.remoteServerSettingsPanel.setSuccessMessage(message);
                        } else {
                            RemoteServerDialog.this.remoteServerSettingsPanel.setErrorMessage(message);
                        }
                        if (finished) {
                            RemoteServerDialog.this.getButton(5210).setEnabled(true);
                        }
                    }
                }

                private boolean canShowMessage() {
                    return RemoteServerDialog.this.getDialogArea() != null && !RemoteServerDialog.this.getDialogArea().isDisposed();
                }
            });
        }
    }
}

