/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.remoteservers;

import com.zeroturnaround.jrebel.remoting.RemoteServerConfiguration;
import com.zeroturnaround.jrebel.remoting.util.ServerConfigurationValidator;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.ui.remoteservers.LocalhostWarningDialog;
import org.zeroturnaround.jrebel.ide.common.IdeRemoting;

public class RemoteServerSettingsPanel {
    private final RemoteServerConfiguration server;
    private Label errorLabel;
    private Text serverNameText;
    private Text serverUrlText;
    private Button useServerAuthenticationCheckbox;
    private Text serverAuthenticationPasswordText;
    private Button useHttpBasicAuthenticationCheckbox;
    private Text httpBasicAuthenticationUserText;
    private Text httpBasicAuthenticationPasswordText;
    private ExpandableComposite securitySettingsPanel;
    private Composite parent;

    public RemoteServerSettingsPanel(RemoteServerConfiguration server) {
        this.server = server;
    }

    public void createContents(Composite outerParent) {
        this.parent = new Composite(outerParent, 0);
        this.parent.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 15;
        this.parent.setLayout((Layout)layout);
        this.errorLabel = RemoteServerSettingsPanel.createErrorLabel(this.parent);
        this.serverNameText = RemoteServerSettingsPanel.createFormInput(this.parent, "Server name", false, this.isNew() ? null : this.server.getName());
        this.serverUrlText = RemoteServerSettingsPanel.createFormInput(this.parent, "Server URL*", false, this.isNew() || this.server.getUrl() == null ? "http://" : this.server.getUrl().toString());
        this.serverUrlText.addModifyListener(e -> {
            URI uRI = this.validateServerUrl();
        });
        Composite inner = this.createExpandableSecuritySettings("Security settings");
        this.useServerAuthenticationCheckbox = this.createCheckbox(inner, "Server authentication", "Enable authentication and data encryption using a server password.", !this.isNew() && this.server.isUseServerAuthentication());
        this.serverAuthenticationPasswordText = RemoteServerSettingsPanel.createFormInput(inner, "Password", true, this.isNew() ? null : this.server.getServerAuthenticationPassword());
        this.useServerAuthenticationCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteServerSettingsPanel.this.updateServerAuthenticationInputEnablement();
            }
        });
        this.useHttpBasicAuthenticationCheckbox = this.createCheckbox(inner, "HTTP Basic authentication", "Enable HTTP Basic authentication for the remote server using the credentials provided.", !this.isNew() && this.server.isUseHttpBasicAuthentication());
        this.httpBasicAuthenticationUserText = RemoteServerSettingsPanel.createFormInput(inner, "User", false, this.isNew() ? null : this.server.getHttpBasicAuthenticationUser());
        this.httpBasicAuthenticationPasswordText = RemoteServerSettingsPanel.createFormInput(inner, "Password", true, this.isNew() ? null : this.server.getHttpBasicAuthenticationPassword());
        this.useHttpBasicAuthenticationCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteServerSettingsPanel.this.updateBasicAuthenticationInputEnablement();
            }
        });
        this.updateBasicAuthenticationInputEnablement();
        this.updateServerAuthenticationInputEnablement();
        if (!this.isNew() && (this.server.isUseServerAuthentication() || this.server.isUseHttpBasicAuthentication())) {
            this.securitySettingsPanel.setExpanded(true);
        }
    }

    private Composite createExpandableSecuritySettings(String string) {
        this.securitySettingsPanel = new ExpandableComposite(this.parent, 0, 2){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                if (!enabled) {
                    this.setExpanded(false);
                }
            }
        };
        this.securitySettingsPanel.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        this.securitySettingsPanel.setText("Security settings");
        SWTUtil.setFontStyle((Control)this.securitySettingsPanel, 1);
        Composite inner = new Composite((Composite)this.securitySettingsPanel, 0);
        inner.setLayout((Layout)new GridLayout(1, false));
        inner.setLayoutData((Object)new GridData(4, 128, false, false));
        this.securitySettingsPanel.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Shell shell = RemoteServerSettingsPanel.this.securitySettingsPanel.getShell();
                shell.pack(true);
            }
        });
        this.securitySettingsPanel.setClient((Control)inner);
        return inner;
    }

    private void updateServerAuthenticationInputEnablement() {
        this.serverAuthenticationPasswordText.setEnabled(this.useServerAuthenticationCheckbox.getSelection());
    }

    private void updateBasicAuthenticationInputEnablement() {
        this.httpBasicAuthenticationUserText.setEnabled(this.useHttpBasicAuthenticationCheckbox.getSelection());
        this.httpBasicAuthenticationPasswordText.setEnabled(this.useHttpBasicAuthenticationCheckbox.getSelection());
    }

    private static Label createErrorLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        label.setForeground(Display.getCurrent().getSystemColor(3));
        return label;
    }

    private static Text createFormInput(Composite parent, String labelText, boolean isPassword, String initialValue) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text inputField = new Text(parent, 0x804 | (isPassword ? 0x400000 : 0));
        inputField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (initialValue != null) {
            inputField.setText(initialValue);
        }
        return inputField;
    }

    private Button createCheckbox(Composite parent, String labelText, String tooltip, boolean initialValue) {
        Button button = new Button(parent, 32);
        button.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        button.setText(labelText);
        button.setSelection(initialValue);
        button.setToolTipText(tooltip);
        return button;
    }

    public RemoteServerConfiguration getWorkingServerCopy() {
        return this.getServerFromInput(true);
    }

    public RemoteServerConfiguration getResult() {
        return this.getServerFromInput(false);
    }

    private RemoteServerConfiguration getServerFromInput(boolean newCopy) {
        URI url;
        RemoteServerConfiguration saveServer;
        this.setErrorMessage("");
        if (!this.validateFormContent()) {
            return null;
        }
        if (!(newCopy || this.verifyUsingLocalhost() && this.verifyUniqueUrl())) {
            return null;
        }
        RemoteServerConfiguration remoteServerConfiguration = saveServer = newCopy || this.isNew() ? new RemoteServerConfiguration() : this.server;
        if (this.serverNameText != null) {
            saveServer.setName(this.serverNameText.getText().trim());
        }
        if ((url = this.validateServerUrl()) == null) {
            return null;
        }
        saveServer.setUrl(url);
        saveServer.setUseServerAuthentication(this.useServerAuthenticationCheckbox.getSelection());
        saveServer.setServerAuthenticationPassword(this.serverAuthenticationPasswordText.getText());
        saveServer.setUseHttpBasicAuthentication(this.useHttpBasicAuthenticationCheckbox.getSelection());
        saveServer.setHttpBasicAuthenticationUser(this.httpBasicAuthenticationUserText.getText());
        saveServer.setHttpBasicAuthenticationPassword(this.httpBasicAuthenticationPasswordText.getText());
        return saveServer;
    }

    private boolean verifyUsingLocalhost() {
        boolean continueWithLocalhost;
        return !RemoteServerConfiguration.isLocalhostUrl((String)this.serverUrlText.getText()) || !this.isServerUrlChanged() || (continueWithLocalhost = LocalhostWarningDialog.openQuestion(Display.getDefault().getActiveShell()));
    }

    private boolean verifyUniqueUrl() {
        List allServers;
        if (!this.isServerUrlChanged()) {
            return true;
        }
        URI url = RemoteServerConfiguration.parseUrl((String)this.serverUrlText.getText());
        String warning = ServerConfigurationValidator.validateServerUriUniqueness((URI)url, (RemoteServerConfiguration)this.server, (List)(allServers = IdeRemoting.getInstance().getConfigurations().getInstanceServers()));
        if (warning != null) {
            this.setErrorMessage(warning);
            return false;
        }
        return true;
    }

    private boolean isServerUrlChanged() {
        return this.server == null || !this.serverUrlText.getText().equalsIgnoreCase(this.server.getUrl().toString());
    }

    public void setErrorMessage(String message) {
        this.errorLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.setMessageAndPack(message);
    }

    public void setSuccessMessage(String message) {
        this.errorLabel.setForeground(Display.getCurrent().getSystemColor(9));
        this.setMessageAndPack(message);
    }

    private void setMessageAndPack(String message) {
        this.errorLabel.setText(message);
        this.errorLabel.pack();
    }

    private URI validateServerUrl() {
        URI url = RemoteServerConfiguration.parseUrl((String)this.serverUrlText.getText());
        this.setErrorMessage(url == null ? "Malformed URL" : "");
        return url;
    }

    private boolean isNew() {
        return this.server == null;
    }

    private boolean validateFormContent() {
        if (this.validateServerUrl() == null) {
            return false;
        }
        if (this.useServerAuthenticationCheckbox.getSelection() && StringUtils.isEmpty((CharSequence)this.serverAuthenticationPasswordText.getText())) {
            this.setErrorMessage("Server security settings are missing!");
            return false;
        }
        if (this.useHttpBasicAuthenticationCheckbox.getSelection() && (StringUtils.isEmpty((CharSequence)this.httpBasicAuthenticationPasswordText.getText()) || StringUtils.isEmpty((CharSequence)this.httpBasicAuthenticationUserText.getText()))) {
            this.setErrorMessage("Server security settings are missing!");
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        Control[] controlArray = this.parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
        if (enabled) {
            this.updateBasicAuthenticationInputEnablement();
            this.updateServerAuthenticationInputEnablement();
        }
    }
}

