/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CustomFormToolkit
extends FormToolkit {
    private static final boolean IS_WS_GTK = "gtk".equals(System.getProperty("osgi.ws"));
    private final Color originalForeground = this.getColors().getForeground();
    private final boolean isKDE = this.isKDE(this.originalForeground);

    public CustomFormToolkit(Display display) {
        super(display);
    }

    public CustomFormToolkit(FormColors colors) {
        super(colors);
    }

    private boolean isKDE(Color fg) {
        return fg.getRed() == 35 && fg.getGreen() == 38 && fg.getBlue() == 41;
    }

    public void adapt(Composite composite) {
        super.adapt(composite);
        if (IS_WS_GTK && this.isKDE && composite instanceof Combo) {
            composite.setBackground(null);
        }
    }

    public void adapt(Control control, boolean trackFocus, boolean trackKeyboard) {
        super.adapt(control, trackFocus, trackKeyboard);
        if (IS_WS_GTK && this.isKDE && control instanceof Button) {
            control.setForeground(this.getColors().getDisplay().getSystemColor(2));
        }
    }
}

