/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.swt;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ScrollBars {
    private static final String KEY_INTENDED_STYLE = "KEY_INTENDED_STYLE";
    public final ScrolledComposite scrolledComposite;
    public final Composite content;

    public ScrollBars(Composite parent, int scrollStyles) {
        parent.setBackgroundMode(2);
        this.scrolledComposite = new ScrolledComposite(parent, scrollStyles);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setBackgroundMode(2);
        this.scrolledComposite.setData(KEY_INTENDED_STYLE, (Object)scrollStyles);
        this.content = new Composite((Composite)this.scrolledComposite, 0);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout contentLayout = new GridLayout(1, false);
        contentLayout.verticalSpacing = 0;
        contentLayout.marginTop = 15;
        contentLayout.marginHeight = 0;
        contentLayout.marginWidth = 0;
        this.content.setLayout((Layout)contentLayout);
        this.scrolledComposite.setContent((Control)this.content);
    }

    public void contentsChanged() {
        ScrollBars.contentsChanged(this.scrolledComposite);
    }

    public static void contentsChanged(Composite contentOfScrolledComposite) {
        Composite c = contentOfScrolledComposite;
        while ((c = c.getParent()) != null && c.getParent() != null && !(c instanceof ScrolledComposite)) {
        }
        if (c instanceof ScrolledComposite) {
            ScrolledComposite scrolledComposite = (ScrolledComposite)c;
            ScrollBars.contentsChanged(scrolledComposite);
        }
    }

    private static void contentsChanged(ScrolledComposite scrolledComposite) {
        Point preferredSize = scrolledComposite.getContent().computeSize(-1, -1, true);
        if (ScrollBars.isVerticallyScrollable((Widget)scrolledComposite)) {
            scrolledComposite.setMinHeight(preferredSize.y);
        }
        if (ScrollBars.isHorizontallyScrollable((Widget)scrolledComposite)) {
            scrolledComposite.setMinWidth(preferredSize.x);
        }
        scrolledComposite.layout(false, true);
    }

    private static boolean isVerticallyScrollable(Widget widget) {
        return (ScrollBars.getStyle(widget) & 0x200) != 0;
    }

    private static boolean isHorizontallyScrollable(Widget widget) {
        return (ScrollBars.getStyle(widget) & 0x100) != 0;
    }

    private static int getStyle(Widget widget) {
        Integer style = (Integer)widget.getData(KEY_INTENDED_STYLE);
        if (style != null) {
            return style;
        }
        return widget.getStyle();
    }
}

