/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyledTextBuilder {
    private final StringBuilder stringBuilder = new StringBuilder("");
    private final List<StyleRange> styleRanges = new ArrayList<StyleRange>();

    public StyledTextBuilder appendCustomStyledText(@NotNull String text, @NotNull TextStyle textStyle, @NotNull FontStyle fontStyle) {
        if (textStyle.font != null && fontStyle != FontStyle.NORMAL) {
            textStyle.font = FontDescriptor.createFrom((Font)textStyle.font).setStyle(fontStyle.fontStyleInt).createFont(textStyle.font.getDevice());
        }
        StyleRange styleRange = new StyleRange(textStyle);
        styleRange.start = this.stringBuilder.length();
        styleRange.length = text.length();
        styleRange.fontStyle = fontStyle.fontStyleInt;
        this.stringBuilder.append(text);
        this.styleRanges.add(styleRange);
        return this;
    }

    public StyledTextBuilder appendText(@NotNull String text) {
        return this.appendCustomStyledText(text, new TextStyle(), FontStyle.NORMAL);
    }

    public StyledTextBuilder appendBoldText(@NotNull String text) {
        return this.appendCustomStyledText(text, new TextStyle(), FontStyle.BOLD);
    }

    public StyledTextBuilder appendLink(@NotNull String linkText, @NotNull Runnable linkListener) {
        TextStyle linkStyle = new TextStyle();
        linkStyle.underline = true;
        linkStyle.underlineStyle = 4;
        linkStyle.data = linkListener;
        return this.appendCustomStyledText(linkText, linkStyle, FontStyle.NORMAL);
    }

    public StyledTextBuilder appendImage(@NotNull Image image) {
        TextStyle imageStyle = new TextStyle();
        imageStyle.metrics = new GlyphMetrics(image.getBounds().height, 0, image.getBounds().width);
        imageStyle.data = image;
        return this.appendCustomStyledText("i", imageStyle, FontStyle.NORMAL);
    }

    public StyledTextBuilder newLine() {
        return this.appendText("\n");
    }

    public StyledTextBuilder newParagraph() {
        return this.appendText("\n\n");
    }

    public StyledText build(@NotNull Composite parent, int swtStyle) {
        StyledText styledText = new StyledText(parent, swtStyle);
        styledText.setText(this.stringBuilder.toString());
        styledText.setStyleRanges(this.styleRanges.toArray(new StyleRange[0]));
        styledText.setEditable(false);
        styledText.addPaintObjectListener(this.drawImagesListener());
        styledText.setCaret(null);
        this.addLinkListener(styledText);
        return styledText;
    }

    private PaintObjectListener drawImagesListener() {
        return event -> {
            StyleRange style = event.style;
            if (style.data instanceof Image) {
                int x = event.x;
                int y = event.y + event.ascent - style.metrics.ascent;
                event.gc.drawImage((Image)style.data, x, y);
            }
        };
    }

    private void addLinkListener(final @NotNull StyledText styledText) {
        styledText.addMouseListener((MouseListener)new MouseAdapter(){
            private StyleRange mouseDownStyleRange = null;

            public void mouseDown(MouseEvent event) {
                this.mouseDownStyleRange = StyledTextBuilder.this.findStyleRangeFromMouseEvent(event, styledText);
            }

            public void mouseUp(MouseEvent event) {
                Object listener;
                StyleRange mouseUpStyleRange = StyledTextBuilder.this.findStyleRangeFromMouseEvent(event, styledText);
                if (this.mouseDownStyleRange != null && this.mouseDownStyleRange.equals((Object)mouseUpStyleRange) && this.mouseDownStyleRange.underline && this.mouseDownStyleRange.underlineStyle == 4 && (listener = this.mouseDownStyleRange.data) instanceof Runnable) {
                    ((Runnable)listener).run();
                }
                this.mouseDownStyleRange = null;
            }
        });
    }

    @Nullable
    private StyleRange findStyleRangeFromMouseEvent(@NotNull MouseEvent event, @NotNull StyledText styledText) {
        try {
            int offset = styledText.getOffsetAtLocation(new Point(event.x, event.y));
            return styledText.getStyleRangeAtOffset(offset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static enum FontStyle {
        NORMAL(0),
        BOLD(1),
        ITALIC(2),
        BOLD_ITALIC(3);

        private final int fontStyleInt;

        private FontStyle(int fontStyleInt) {
            this.fontStyleInt = fontStyleInt;
        }
    }
}

