/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.swt;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.jetbrains.annotations.Nullable;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.ui.swt.BoldLabel;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ZtLabel {
    private static final Log log = Log.getInstance(ZtLabel.class);
    private final Composite drawArea;
    private Composite row;
    private Control lastTooltipEnabledObject;

    public ZtLabel(Composite outerParent) {
        this.drawArea = new Composite(outerParent, 0);
        this.drawArea.setLayout((Layout)new RowLayout(512));
        this.newRow();
    }

    private void newRow() {
        this.lastTooltipEnabledObject = null;
        this.row = new Composite(this.drawArea, 0);
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        if (EnvironmentUtil.isMac()) {
            layout.spacing = 0;
        }
        layout.marginRight = 0;
        layout.marginLeft = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.row.setLayout((Layout)layout);
    }

    public ZtLabel text(String text) {
        Label label = new Label(this.row, 0);
        label.setText(text);
        this.lastTooltipEnabledObject = label;
        return this;
    }

    public ZtLabel fromText(String text, Listener listener) {
        this.lastTooltipEnabledObject = null;
        List<String> lines = Arrays.asList(text.split("<br />"));
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next();
            Link textWithLink = new Link(this.row, 0);
            textWithLink.setText(line);
            textWithLink.addListener(13, listener);
            if (!it.hasNext()) continue;
            this.newline();
        }
        return this;
    }

    public ZtLabel tooltip(String tooltip) {
        if (this.lastTooltipEnabledObject != null) {
            this.lastTooltipEnabledObject.setToolTipText(tooltip);
        } else {
            log.warn("Couldn't add tooltip, because none of recently added components support it", new Throwable());
        }
        return this;
    }

    public ZtLabel bold(String text) {
        this.lastTooltipEnabledObject = new BoldLabel(this.row, text).getControl();
        return this;
    }

    public ZtLabel macSafeBold(String text) {
        if (EnvironmentUtil.isMac()) {
            return this.text(text);
        }
        return this.bold(text);
    }

    public ZtLabel link(String text, Listener listener) {
        Link link = new Link(this.row, 0);
        link.setText("<a>" + text + "</a>");
        link.addListener(13, listener);
        this.lastTooltipEnabledObject = link;
        return this;
    }

    public ZtLabel newline() {
        this.newRow();
        return this;
    }

    public ZtLabel image(Image icon) {
        Label label = new Label(this.row, 0);
        label.setImage(icon);
        return this;
    }

    public void setVisible(boolean visible) {
        this.drawArea.setVisible(visible);
    }

    @Nullable
    public Control lastDisableableObject() {
        return this.lastTooltipEnabledObject;
    }

    public ZtLabel clear() {
        Control[] controlArray = this.drawArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.drawArea.pack();
        this.newRow();
        return this;
    }
}

