/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.ui.tabs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.RebelLaunchConfigProviders;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.ui.SWTFactory;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelTab
extends AbstractLaunchConfigurationTab {
    private static final Log log = Log.getInstance(JRebelTab.class);
    protected Button fLaunchRebelButton;
    protected Button fLaunchXRebelButton;
    private boolean argsApplied;
    protected IRebelLaunchConfig adaptor;

    private void initAdaptor(ILaunchConfiguration config) {
        if (this.adaptor == null) {
            this.adaptor = RebelLaunchConfigProviders.createRebelLaunchConfig(config);
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setFont(parent.getFont());
        this.setControl((Control)comp);
        this.createLaunchRebelComponent(comp);
    }

    private void createLaunchRebelComponent(Composite parent) {
        Group jrebelGroup = SWTFactory.createGroup(parent, "JRebel", 1, 1, 768);
        this.fLaunchRebelButton = this.createCheckButton((Composite)jrebelGroup, "Enable JRebel agent");
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        this.fLaunchRebelButton.setLayoutData((Object)data);
        this.fLaunchRebelButton.setFont(parent.getFont());
        this.fLaunchRebelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelTab.this.rebelCheckboxChanged();
            }
        });
        Group xrebelGroup = SWTFactory.createGroup(parent, "XRebel", 1, 1, 768);
        this.fLaunchXRebelButton = this.createCheckButton((Composite)xrebelGroup, "Enable XRebel agent");
        this.fLaunchXRebelButton.setLayoutData((Object)data);
        this.fLaunchXRebelButton.setFont(parent.getFont());
        this.fLaunchXRebelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRebelTab.this.rebelCheckboxChanged();
            }
        });
        if (!JRebel.isConfigured()) {
            this.fLaunchRebelButton.setEnabled(false);
            this.fLaunchXRebelButton.setEnabled(false);
        }
    }

    public String getName() {
        return "JRebel and XRebel";
    }

    public Image getImage() {
        return RebelImage.JREBEL.getImage();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.initAdaptor(config);
        if (this.adaptor != null) {
            this.fLaunchRebelButton.setSelection(this.adaptor.isJRebelEnabled(config));
            this.fLaunchXRebelButton.setSelection(this.adaptor.isXRebelEnabled(config));
        }
        this.setDirty(false);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        try {
            this.initAdaptor((ILaunchConfiguration)config);
            if (this.adaptor != null) {
                this.adaptor.setJRebelEnabled(config, false);
                this.adaptor.setXRebelEnabled(config, false);
                this.refreshArgumentsTab(config);
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    protected void refreshArgumentsTab(ILaunchConfigurationWorkingCopy configuration) {
        ILaunchConfigurationDialog dialog = this.getLaunchConfigurationDialog();
        if (dialog == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = dialog.getTabs();
        if (tabs == null) {
            return;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof JavaArgumentsTab || tab instanceof JavaClasspathTab || tab instanceof EnvironmentTab) {
                tab.setLaunchConfigurationDialog(null);
                if (configuration.getOriginal() != null) {
                    tab.initializeFrom(configuration.getOriginal());
                }
                tab.initializeFrom((ILaunchConfiguration)configuration);
                tab.setLaunchConfigurationDialog(dialog);
            }
            ++n2;
        }
    }

    protected void applyArgumentsTab(ILaunchConfigurationWorkingCopy config) {
        ILaunchConfigurationDialog dialog = this.getLaunchConfigurationDialog();
        if (dialog == null) {
            return;
        }
        ILaunchConfigurationTab[] tabs = dialog.getTabs();
        if (tabs == null) {
            return;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab instanceof JavaArgumentsTab) {
                tab.performApply(config);
            }
            ++n2;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        log.debug("performApply, wc: {}", (Object)config);
        if (this.shouldApplyChanges()) {
            this.applyChanges(config);
            if (!this.argsApplied) {
                this.argsApplied = true;
                this.refreshArgumentsTab(config);
            }
        }
    }

    private boolean shouldApplyChanges() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < Math.min(10, stack.length)) {
            StackTraceElement ste = stack[i];
            if ("handleApplyPressed".equals(ste.getMethodName())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void applyChanges(ILaunchConfigurationWorkingCopy config) {
        try {
            this.initAdaptor((ILaunchConfiguration)config);
            if (this.adaptor != null) {
                this.adaptor.setJRebelEnabled(config, this.fLaunchRebelButton.getSelection());
                this.adaptor.setXRebelEnabled(config, this.fLaunchXRebelButton.getSelection());
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    protected void rebelCheckboxChanged() {
        this.argsApplied = false;
        this.updateLaunchConfigurationDialog();
        this.setDirty(true);
    }
}

