/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.update;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.update.PluginLatestVersionProvider;

public class EclipsePluginLatestVersionProvider
implements PluginLatestVersionProvider {
    private static final Log log = Log.getInstance(EclipsePluginLatestVersionProvider.class);
    private final AtomicReference<String> version = new AtomicReference<Object>(null);

    @Nullable
    public String getLatestVersion() {
        if (this.version.get() == null) {
            this.version.set(this.getLatestVersionOnline());
        }
        return StringUtils.trimToNull((String)this.version.get());
    }

    @NotNull
    private String getLatestVersionOnline() {
        try {
            return this.getLatestVersionInternal();
        }
        catch (Exception e) {
            log.warn("Loading latest version failed: {}", (Throwable)e);
            return "";
        }
    }

    private String getLatestVersionInternal() {
        IMetadataRepositoryManager repoManger = this.getRepoManager();
        if (repoManger == null) {
            log.info("Repo manager not enabled");
            return "";
        }
        URI ztRepo = this.findZtRepo(this.getKnownRepos(repoManger));
        if (ztRepo == null) {
            log.info("ZT eclipse release repo not enabled");
            return "";
        }
        IMetadataRepository repo = this.refreshRepository(repoManger, ztRepo);
        List<IInstallableUnit> result = this.getMainFeature(repo);
        if (result.isEmpty()) {
            log.warn("No feature found in repository: {}", (Object)repo);
            return "";
        }
        IInstallableUnit unit = result.get(0);
        if (!this.hasRequirements(repoManger, unit)) {
            return "";
        }
        String version = unit.getVersion().toString();
        return PlatformInfo.normalizeVersion(version);
    }

    private boolean hasRequirements(IMetadataRepositoryManager repoManger, IInstallableUnit unit) {
        for (Object r : unit.getRequirements()) {
            ExpressionMatchQuery query = new ExpressionMatchQuery(IInstallableUnit.class, (IExpression)((IRequirement)r).getMatches(), new Object[0]);
            IQueryResult rMatches = repoManger.query((IQuery)query, (IProgressMonitor)new NullProgressMonitor());
            if (!rMatches.isEmpty()) continue;
            log.warn("No matches for dependency: {}", r);
            return false;
        }
        return true;
    }

    private List<IInstallableUnit> getMainFeature(IMetadataRepository repo) {
        ExpressionMatchQuery query = new ExpressionMatchQuery(IInstallableUnit.class, "id == $0", new Object[]{"org.zeroturnaround.eclipse.feature.feature.group"});
        IQueryResult result = repo.query((IQuery)query, (IProgressMonitor)new NullProgressMonitor());
        return new ArrayList<IInstallableUnit>(result.toSet());
    }

    private IMetadataRepository refreshRepository(IMetadataRepositoryManager repoManger, URI uri) {
        try {
            return repoManger.refreshRepository(uri, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException | ProvisionException e) {
            throw new IllegalStateException(e);
        }
    }

    private URI findZtRepo(Collection<URI> repos) {
        for (URI u : repos) {
            String path = u.getPath();
            path = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (!"update.zeroturnaround.com".equals(u.getHost()) || !path.startsWith("/update-site/")) continue;
            return u;
        }
        return null;
    }

    private Collection<URI> getKnownRepos(IMetadataRepositoryManager repoManger) {
        Object[] knownRepositories = repoManger.getKnownRepositories(0);
        log.info("Enabled repos: {}", (Object)Arrays.toString(knownRepositories));
        return new LinkedHashSet<Object>(Arrays.asList(knownRepositories));
    }

    private IMetadataRepositoryManager getRepoManager() {
        BundleContext bundleContext = RebelPlugin.getDefault().getBundle().getBundleContext();
        ServiceReference srpa = bundleContext.getServiceReference(IProvisioningAgent.class.getName());
        if (srpa == null) {
            return null;
        }
        IProvisioningAgent pa = (IProvisioningAgent)bundleContext.getService(srpa);
        return (IMetadataRepositoryManager)pa.getService(IMetadataRepositoryManager.SERVICE_NAME);
    }
}

