/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.util;

import com.zeroturnaround.jrebel.ide.common.IdeModule;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.jetbrains.annotations.NotNull;
import org.zeroturnaround.eclipse.EclipseIdeProject;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.eclipse.servers.ServerConfigProviders;
import org.zeroturnaround.eclipse.util.EclipseJob;
import org.zeroturnaround.jrebel.client.logger.Log;

public class EclipseUtil {
    private static final Log log = Log.getInstance(EclipseUtil.class);
    public static IWorkspace TEST_WORKSPACE = null;

    public static void runCommand(final String commandId, final Event event) {
        log.info("Running command: {}, event: {}", (Object)commandId, (Object)event);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EclipseUtil.getHandlerService().executeCommand(commandId, event);
                }
                catch (Exception e) {
                    log.error("Failed to execute command with id {}", (Object)commandId, (Object)e);
                }
            }
        });
    }

    private static IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
    }

    public static void openUpdateWindow() {
        EclipseUtil.runCommand("org.eclipse.equinox.p2.ui.sdk.update", null);
    }

    public static void runInUiThread(Runnable runnable) {
        EclipseUtil.runWithoutWrappingInUiThread(EclipseUtil.wrapWithLogging(runnable));
    }

    private static void runWithoutWrappingInUiThread(Runnable runnable) {
        if (EclipseUtil.isUiThread()) {
            runnable.run();
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    private static Runnable wrapWithLogging(final Runnable r) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (RuntimeException re) {
                    log.warn("Async runnable failed with RuntimeException: {}", (Object)r, (Object)re);
                    throw re;
                }
                catch (Exception e) {
                    log.warn("Async runnable failed: {}", (Object)r, (Object)e);
                }
            }
        };
    }

    private static boolean isUiThread() {
        return Display.getCurrent() != null;
    }

    public static int getWorkspaceJavaProjectsCount() {
        IProject[] projects;
        int result = 0;
        IProject[] iProjectArray = projects = EclipseUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (ProjectHelper.isJavaProject(p)) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public static int getWorkspaceServersCount() {
        return ServerConfigProviders.getServersCount();
    }

    public static void runJobsBlocking(List<EclipseJob> jobs) {
        EclipseUtil.runJobsBlocking(jobs, Integer.MAX_VALUE);
    }

    public static void runJobsBlocking(List<EclipseJob> jobs, int concurrentLimit) {
        if (concurrentLimit < 1) {
            throw new IllegalArgumentException("concurrentLimit must be not under 1");
        }
        final CountDownLatch latch = new CountDownLatch(jobs.size());
        final Semaphore semaphore = new Semaphore(concurrentLimit, true);
        for (final EclipseJob eclipseJob : jobs) {
            try {
                semaphore.acquire();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            Job job = new Job(eclipseJob.getName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            eclipseJob.run(monitor);
                        }
                        catch (Exception e) {
                            log.error("Failed to run job", (Throwable)e);
                            latch.countDown();
                            semaphore.release();
                        }
                    }
                    finally {
                        latch.countDown();
                        semaphore.release();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static File getWorkspaceRoot() {
        IWorkspaceRoot workspaceRoot = EclipseUtil.getWorkspace().getRoot();
        IPath location = workspaceRoot.getLocation();
        return location.toFile().getAbsoluteFile();
    }

    public static IProject[] getAllProjects() {
        return EclipseUtil.getWorkspace().getRoot().getProjects();
    }

    @NotNull
    public static List<IdeModule> toIdeModules(List<IProject> projects) {
        ArrayList<IdeModule> modules = new ArrayList<IdeModule>();
        for (IProject project : projects) {
            if (!project.isOpen()) continue;
            modules.add(new EclipseIdeProject(project));
        }
        return modules;
    }

    public static IWorkspace getWorkspace() {
        return TEST_WORKSPACE != null ? TEST_WORKSPACE : ResourcesPlugin.getWorkspace();
    }

    public static IJavaProject getJavaProject(IProject project) {
        if (project != null && EclipseUtil.isJavaProject(project)) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean isJavaProject(IProject project) {
        return EclipseUtil.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean hasNature(IProject project, String natureId) {
        try {
            return project != null && project.hasNature(natureId);
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

