/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.variable;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jdt.launching.JavaRuntime;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.store.StringArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.util.AgentValidationUtil;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.args.EclipseLaunchingArgs;
import org.zeroturnaround.eclipse.launching.support.JVMHelper;
import org.zeroturnaround.eclipse.util.EclipseMetricsUtil;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public class RebelArgsResolver
implements IDynamicVariableResolver {
    private static final Log log = Log.getInstance(RebelArgsResolver.class);
    public static final String PADDED_SUFFIX = "padded";
    public static final String UNQUOTED_SUFFIX = "unquoted";
    public static final String JREBEL_ARGS = "jrebel_args";
    public static final String JREBEL_ARGS_UNQUOTED = "jrebel_args.unquoted";
    public static final String JREBEL_ARGS_PADDED = "jrebel_args.padded";
    public static final String XREBEL_ARGS = "jrebel_xr_args";
    public static final String XREBEL_ARGS_UNQUOTED = "jrebel_xr_args.unquoted";
    public static final String XREBEL_ARGS_PADDED = "jrebel_xr_args.padded";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        log.info("resolveValue() var[{}] argument[{}]", (Object)variable.getName(), (Object)argument);
        log.trace("current workspace root " + EclipseUtil.getWorkspaceRoot());
        log.trace("current workspace root " + EclipseMetricsUtil.getWorkspaceLocationHash());
        if (variable.getName().startsWith(JREBEL_ARGS)) {
            return this.resolveJRebelValue(variable, argument);
        }
        if (variable.getName().startsWith(XREBEL_ARGS)) {
            return this.resolveXRebelValue(variable, argument);
        }
        return "";
    }

    private String resolveXRebelValue(IDynamicVariable variable, String argument) throws CoreException {
        ArgFormatter formatter = !XREBEL_ARGS_UNQUOTED.equals(variable.getName()) ? ArgFormatter.QUOTED : ArgFormatter.SHORT_FILE_NAMES;
        StringArgStore store = new StringArgStore("", formatter, false);
        return store.preview(EclipseLaunchingArgs.getXRebelJVMArgAdditions());
    }

    private String resolveJRebelValue(final IDynamicVariable variable, String argument) throws CoreException {
        log.trace("resolveJRebelValue trace 01");
        if (!JRebel.isConfigured()) {
            if (JRebel.isExternalAgentSelected()) {
                AgentValidationUtil.logSwitchedToEmbedded();
                JRebelClientAdapter.getInstance().getClientSettings().switchJRebelClientToGriffin();
            }
            if (!JRebel.isConfigured()) {
                return "";
            }
        }
        log.trace("resolveJRebelValue trace 02");
        final JavaVM vm = this.resolveVm(argument);
        final AtomicReference args = new AtomicReference();
        Job job = new Job("Enabling JRebel for launch (may take a few seconds the first time)"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Computing JRebel VM arguments", -1);
                try {
                    args.set(RebelArgsResolver.this.resolveVariable(variable, vm, monitor));
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    log.warn("Unable to resolve arguments", (Throwable)e);
                    args.set("");
                    return RebelPlugin.newErrorStatus(e.getMessage(), e);
                }
            }
        };
        job.schedule();
        try {
            log.trace("resolveJRebelValue trace 03");
            job.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        log.trace("resolveJRebelValue trace 04");
        if (JREBEL_ARGS_PADDED.equals(variable.getName())) {
            return String.format(" %s ", args.get());
        }
        return (String)args.get();
    }

    private String resolveVariable(IDynamicVariable variable, JavaVM vm, IProgressMonitor monitor) throws CoreException {
        log.trace("resolveVariable trace 01");
        boolean quoted = !JREBEL_ARGS_UNQUOTED.equals(variable.getName());
        StringArgStore store = new StringArgStore("", quoted ? ArgFormatter.QUOTED : ArgFormatter.SHORT_FILE_NAMES, false);
        log.trace("resolveVariable trace 02");
        String args = store.preview(EclipseLaunchingArgs.getJVMArgAdditions(vm, monitor));
        log.info("RebelArgsResolver.resolveVariable() quoted: {}, value: '{}'", (Object)quoted, (Object)args);
        return args;
    }

    private JavaVM resolveVm(String argument) throws CoreException {
        log.trace("resolveVM for {}", (Object)argument);
        JavaVM jvm = null;
        if (argument != null && !argument.trim().isEmpty()) {
            jvm = argument.startsWith("JAVA_HOME=") ? JavaVM.getJavaJVM((String)argument.substring(10)) : (argument.startsWith(JavaRuntime.JRE_CONTAINER) ? JVMHelper.getJavaVM(JavaRuntime.getVMInstall((IPath)new Path(argument))) : JVMHelper.getJavaVM(JavaRuntime.getVMInstall((IPath)new Path(String.valueOf(JVMHelper.STANDARD_VM_PREFIX) + argument))));
        }
        return jvm != null ? jvm : JVMHelper.getJavaVM(JavaRuntime.getDefaultVMInstall());
    }
}

