/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.EclipseJRebelClientAdapter;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.PlatformInfo;
import org.zeroturnaround.eclipse.wtp.launching.AutomaticPublishing;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.RebelServerProviders;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

public class BootstrapPreGeneratorForServers
implements IStartup {
    private static final Log log = Log.getInstance(BootstrapPreGeneratorForServers.class);
    private static String KEY_AUTO_ENABLED_SERVERS = "jrebel.eclipse.plugin.wtp.autoenabled";
    private static final ISchedulingRule mutex = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public void earlyStartup() {
        log.info("BootstrapPreGeneratorForServers.earlyStartup. ");
        JRebel jrebel = JRebel.getDefault();
        this.forAll(jrebel);
    }

    private void forAll(final JRebel jrebel) {
        Preferences prefs = RebelPlugin.getDefault().getPluginPreferences();
        String val = prefs.getString("jrebel.eclipse.plugin.version");
        log.debug("jrebel.eclipse.plugin.version=" + val);
        boolean newVersionInstalled = false;
        String currentVersion = PlatformInfo.getJRebelPluginVersion();
        if (val == null || !val.equals(currentVersion)) {
            log.trace("different from current " + currentVersion);
            newVersionInstalled = true;
            prefs.setValue("jrebel.eclipse.plugin.version", currentVersion);
            log.trace("saved current to prefs");
        }
        if (newVersionInstalled) {
            BootstrapPreGeneratorForServers.upgradeServerConf("Updating server configurations after JRebel upgrade");
        }
        boolean autoenabled = BootstrapPreGeneratorForServers.isAutoEnabled();
        log.info("autoenabled=" + autoenabled);
        if (!autoenabled) {
            BootstrapPreGeneratorForServers.setAutoEnabled(true);
            BootstrapPreGeneratorForServers.changeJRebelEnablementForExistingServers(true);
        }
        Job job = new Job("Pre-generating JRebel bootstrap caches for servers"){

            protected IStatus run(IProgressMonitor monitor) {
                log.info("running job  " + this.getName());
                IServer[] servers = ServerCore.getServers();
                ProgressMonitor mon = EclipseJRebelClientAdapter.wrapMonitor((IProgressMonitor)monitor);
                monitor.beginTask("Pre-generating JRebel bootstrap caches for servers", servers.length);
                IServer[] iServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    block12: {
                        IServer server = iServerArray[n2];
                        if (monitor.isCanceled()) break;
                        IRebelServer adapter = RebelServerProviders.createRebelServer(server);
                        if (adapter != null) {
                            JavaVM jvm;
                            block11: {
                                jvm = adapter.getJVM(server);
                                if (!monitor.isCanceled()) break block11;
                                monitor.worked(1);
                                break;
                            }
                            try {
                                if (jvm != null && jrebel.supports(jvm) && jrebel.needsBootstrapWith(jvm)) {
                                    jrebel.getBootstrapJarFile(jvm, mon);
                                }
                            }
                            catch (CoreException e) {
                                log.warn("Problem while pre-generating bootstrap", (Throwable)e);
                                monitor.worked(1);
                                break block12;
                            }
                            catch (Exception e) {
                                try {
                                    log.warn("Problem while pre-generating bootstrap", (Throwable)e);
                                    break block12;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    monitor.worked(1);
                                }
                            }
                            monitor.worked(1);
                        }
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(mutex);
        job.schedule();
    }

    static void upgradeServerConf(String upgradeReason) {
        Job job = new Job(upgradeReason){

            protected IStatus run(IProgressMonitor monitor) {
                log.info("running job  " + this.getName());
                IServer[] servers = ServerCore.getServers();
                monitor.beginTask(this.getName(), servers.length);
                IServer[] iServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        IServer server = iServerArray[n2];
                        log.info("server " + server);
                        if (monitor.isCanceled()) break;
                        IRebelServer adapter = RebelServerProviders.createRebelServer(server);
                        try {
                            try {
                                if (adapter != null) {
                                    boolean isEnabled = adapter.isJRebelEnabled(server);
                                    log.info("isEnabled " + isEnabled);
                                    if (isEnabled) {
                                        adapter.setJRebelEnabled(BootstrapPreGeneratorForServers.getWorkingCopy(server), false);
                                        log.info("disabled JRebel");
                                        adapter.setJRebelEnabled(BootstrapPreGeneratorForServers.getWorkingCopy(server), true);
                                        log.info("reenabled JRebel");
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.warn("Problem while updating server", (Throwable)e);
                                monitor.worked(1);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            throw throwable;
                        }
                        monitor.worked(1);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule(mutex);
        job.schedule();
    }

    protected static void setAutoEnabled(boolean value) {
        Preferences prefs = RebelPlugin.getDefault().getPluginPreferences();
        prefs.setValue(KEY_AUTO_ENABLED_SERVERS, value);
    }

    protected static boolean isAutoEnabled() {
        Preferences prefs = RebelPlugin.getDefault().getPluginPreferences();
        return prefs.getBoolean(KEY_AUTO_ENABLED_SERVERS);
    }

    protected static void changeJRebelEnablementForExistingServers(final boolean enable) {
        Job job = new Job(String.valueOf(enable ? "Enabling" : "Disabling") + " JRebel for existing servers"){

            protected IStatus run(IProgressMonitor monitor) {
                log.info("running job  " + this.getName());
                IServer[] servers = ServerCore.getServers();
                monitor.beginTask(this.getName(), servers.length);
                ArrayList<String> updatedServers = new ArrayList<String>();
                IServer[] iServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        IServer server = iServerArray[n2];
                        log.info("Trying to update JRebel enablement on {}", (Object)server.getName());
                        if (monitor.isCanceled()) break;
                        IRebelServer adapter = RebelServerProviders.createRebelServer(server);
                        try {
                            try {
                                if (adapter != null) {
                                    boolean isEnabled = adapter.isJRebelEnabled(server);
                                    log.info("JRebel already enabled on server: {} Going to flip setting: {}", (Object)isEnabled, (Object)(enable ^ isEnabled));
                                    if (enable != isEnabled) {
                                        ServerLaunchables.bind(server, adapter).setJRebelEnabled(enable, updatedServers::add);
                                        log.info("{} JRebel on {}", (Object)(enable ? "enabled" : "disabled"), (Object)server.getName());
                                    }
                                }
                            }
                            catch (Exception e) {
                                log.warn("Problem while updating server", (Throwable)e);
                                monitor.worked(1);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            throw throwable;
                        }
                        monitor.worked(1);
                    }
                    ++n2;
                }
                log.info("Updated publishing setting on {} servers", (Object)updatedServers.size());
                AutomaticPublishing.notifyAutoPublishChanged(updatedServers, !enable);
                return Status.OK_STATUS;
            }
        };
        job.setRule(mutex);
        job.schedule();
    }

    private static IServerWorkingCopy getWorkingCopy(IServer launchable) throws CoreException {
        if (launchable instanceof IServerWorkingCopy) {
            return (IServerWorkingCopy)launchable;
        }
        return launchable.createWorkingCopy();
    }
}

