/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.IEJBModule;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IUtilityModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.zeroturnaround.eclipse.actions.extension.IRebelXmlContributor;
import org.zeroturnaround.eclipse.actions.extension.RebelClasspathEntry;
import org.zeroturnaround.eclipse.actions.extension.RebelWebEntry;

public class NewRebelXmlContributor
implements IRebelXmlContributor {
    private static final List<String> KNOWN_JAVA_MODULE_IDS = Arrays.asList("jst.utility", "jst.web", "jst.ejb");

    public boolean isHandlingDefaultClassPathEntries(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules != null) {
            IModule[] iModuleArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                IModule module = iModuleArray[n2];
                if (KNOWN_JAVA_MODULE_IDS.contains(module.getModuleType().getId()) && this.checkAdapter(module)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean checkAdapter(IModule module) {
        String moduleTypeId = module.getModuleType().getId();
        IWebModule adapter = null;
        if ("jst.utility".equals(moduleTypeId)) {
            IUtilityModule utilityAdapter = (IUtilityModule)module.loadAdapter(IUtilityModule.class, null);
            if (utilityAdapter != null) {
                IContainer[] javaOutputFolders = utilityAdapter.getJavaOutputFolders();
                return this.anyExist(javaOutputFolders);
            }
            adapter = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null);
        } else if ("jst.web".equals(moduleTypeId)) {
            adapter = (IWebModule)module.loadAdapter(IWebModule.class, null);
        } else if ("jst.ejb".equals(moduleTypeId)) {
            adapter = (IEJBModule)module.loadAdapter(IEJBModule.class, null);
        }
        if (adapter != null) {
            IContainer[] javaOutputFolders = adapter.getJavaOutputFolders();
            return this.anyExist(javaOutputFolders);
        }
        return false;
    }

    protected boolean anyExist(IContainer[] javaOutputFolders) {
        if (javaOutputFolders != null) {
            IContainer[] iContainerArray = javaOutputFolders;
            int n = javaOutputFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer outputFolder = iContainerArray[n2];
                if (outputFolder.exists()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public List<RebelClasspathEntry> getClasspathEntries(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules == null) {
            return Collections.emptyList();
        }
        ArrayList<RebelClasspathEntry> entries = new ArrayList<RebelClasspathEntry>();
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if ("jst.utility".equals(module.getModuleType().getId())) {
                IUtilityModule javaModule = (IUtilityModule)module.loadAdapter(IUtilityModule.class, null);
                if (javaModule != null) {
                    this.addClasspathEntries(entries, javaModule.getJavaOutputFolders());
                } else {
                    this.addClasspathEntries(entries, (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, null));
                }
            }
            if ("jst.web".equals(module.getModuleType().getId())) {
                this.addClasspathEntries(entries, (IJ2EEModule)((IWebModule)module.loadAdapter(IWebModule.class, null)));
            }
            if ("jst.ejb".equals(module.getModuleType().getId())) {
                this.addClasspathEntries(entries, (IJ2EEModule)((IEJBModule)module.loadAdapter(IEJBModule.class, null)));
            }
            ++n2;
        }
        return entries;
    }

    private void addClasspathEntries(List<RebelClasspathEntry> entries, IJ2EEModule module) {
        if (module != null) {
            this.addClasspathEntries(entries, module.getJavaOutputFolders());
        }
    }

    private void addClasspathEntries(List<RebelClasspathEntry> entries, IContainer[] javaOutputFolders) {
        IContainer[] iContainerArray = javaOutputFolders;
        int n = javaOutputFolders.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer outputFolder = iContainerArray[n2];
            if (outputFolder.exists()) {
                entries.add(new RebelClasspathEntry(outputFolder.getLocation()));
            }
            ++n2;
        }
    }

    public List<RebelWebEntry> getWebPathEntries(IProject project) {
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules == null) {
            return Collections.emptyList();
        }
        final ArrayList<RebelWebEntry> webEntries = new ArrayList<RebelWebEntry>();
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if ("jst.web".equals(module.getModuleType().getId())) {
                IVirtualResource[] vResources;
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                IVirtualFolder rootFolder = component.getRootFolder();
                if (!rootFolder.exists() || !rootFolder.getUnderlyingResource().exists()) break;
                IPath mainRootFolderPath = rootFolder.getUnderlyingResource().getProjectRelativePath();
                HashSet<IVirtualResource> seenResource = new HashSet<IVirtualResource>();
                IVirtualResource[] iVirtualResourceArray = vResources = ComponentCore.createResources((IResource)project);
                int n3 = vResources.length;
                int n4 = 0;
                while (n4 < n3) {
                    final IVirtualResource vResource = iVirtualResourceArray[n4];
                    if (vResource.exists() && !seenResource.contains(vResource)) {
                        seenResource.add(vResource);
                        if (!new Path("/WEB-INF/classes").equals((Object)vResource.getRuntimePath())) {
                            IResource[] uResources;
                            IResource[] iResourceArray = uResources = vResource.getUnderlyingResources();
                            int n5 = uResources.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IResource uResource = iResourceArray[n6];
                                if (uResource.exists()) {
                                    RebelWebEntry webEntry = new RebelWebEntry(uResource.getLocation());
                                    webEntry.contextPath(vResource.getRuntimePath().toPortableString());
                                    if ("/".equals(webEntry.getContextPath()) && !uResource.getProjectRelativePath().equals((Object)mainRootFolderPath)) {
                                        webEntry.excludes("/");
                                    }
                                    webEntries.add(webEntry);
                                    try {
                                        final IPath projRelPath = uResource.getProjectRelativePath();
                                        IFolder folder = project.getFolder(projRelPath);
                                        if (folder != null && folder.exists()) {
                                            folder.accept(new IResourceVisitor(){

                                                public boolean visit(IResource res) throws CoreException {
                                                    if (res.getType() == 2 && res.isLinked()) {
                                                        if (projRelPath.isPrefixOf(res.getProjectRelativePath())) {
                                                            RebelWebEntry subEntry = new RebelWebEntry(res.getLocation());
                                                            IPath relPath = res.getProjectRelativePath().makeRelativeTo(projRelPath);
                                                            subEntry.contextPath(vResource.getRuntimePath().append(relPath).toPortableString());
                                                            webEntries.add(subEntry);
                                                        }
                                                        return false;
                                                    }
                                                    return true;
                                                }
                                            });
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                                ++n6;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return webEntries;
    }
}

