/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp;

import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.osgi.framework.BundleContext;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeAdapter;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeListener;
import org.zeroturnaround.eclipse.plugins.PluginProvisioningListener;
import org.zeroturnaround.eclipse.wtp.BootstrapPreGeneratorForServers;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerLifecycleListener;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelWTPPlugin
extends AbstractUIPlugin {
    private static final Log log = Log.getInstance(RebelWTPPlugin.class);
    public static final String PLUGIN_ID = "org.zeroturnaround.eclipse.wtp";
    private static RebelWTPPlugin plugin;
    private IServerLifecycleListener serverLifecycleListener = new ServerLifecycleListener();
    private JRebelServiceChangeAdapter serviceChangeListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        if (log.isTraceEnabled()) {
            log.trace("start");
        }
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        this.addProvisioningListener(context);
        this.serviceChangeListener = new JRebelServiceChangeAdapter(){

            public void startupConfigurationChangedEvent() {
                BootstrapPreGeneratorForServers.upgradeServerConf("Updating server configurations");
            }
        };
        RebelPlugin.getJRebelService().addListener((JRebelServiceChangeListener)this.serviceChangeListener);
    }

    private void addProvisioningListener(BundleContext context) {
        try {
            PluginProvisioningListener listener = new PluginProvisioningListener(PLUGIN_ID){

                protected void onUninstall() {
                    BootstrapPreGeneratorForServers.changeJRebelEnablementForExistingServers(false);
                    BootstrapPreGeneratorForServers.setAutoEnabled(false);
                    log.info("reset automatic server enabling");
                }

                protected void onUpgrade(Version oldVersion, Version newVersion) {
                }
            };
            listener.addToContext(context);
        }
        catch (Exception e) {
            log.debug("got exception while setting up provisioning listener. " + e.toString());
        }
    }

    public void stop(BundleContext context) throws Exception {
        RebelPlugin.getJRebelService().removeListener((JRebelServiceChangeListener)this.serviceChangeListener);
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        plugin = null;
        super.stop(context);
    }

    public static RebelWTPPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return RebelWTPPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

