/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.config.servers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.zeroturnaround.eclipse.nature.ProjectHelper;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ServerHelper {
    private static final Log log = Log.getInstance(ServerHelper.class);
    private static boolean noPublicAPIForGetSetAttribute = false;
    private static Method getAttributeInt;
    private static Method setAttributeInt;
    private static Method getAttributeString;
    private static Method setAttributeString;
    private static Method getAttributeMap;

    public static boolean hasJRebelModules(IServer server) {
        return ServerHelper.anyJRebelModules(server.getModules(), server);
    }

    private static boolean anyJRebelModules(IModule[] modules, IServer server) {
        if (modules == null || modules.length == 0) {
            return false;
        }
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (ProjectHelper.isJRebelProject((IProject)module.getProject())) {
                return true;
            }
            ++n2;
        }
        IModule[] childModules = server.getChildModules(modules, (IProgressMonitor)new NullProgressMonitor());
        return ServerHelper.anyJRebelModules(childModules, server);
    }

    public static boolean hasJavaModules(IServer server) {
        return ServerHelper.anyJavaModules(server.getModules(), server);
    }

    private static boolean anyJavaModules(IModule[] modules, IServer server) {
        if (modules == null || modules.length == 0) {
            return false;
        }
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            if (ProjectHelper.isJavaProject((IProject)module.getProject())) {
                return true;
            }
            ++n2;
        }
        IModule[] childModules = server.getChildModules(modules, (IProgressMonitor)new NullProgressMonitor());
        return ServerHelper.anyJavaModules(childModules, server);
    }

    public static int getAttribute(IServerAttributes attrs, String name, int defaultValue) {
        if (getAttributeInt == null) {
            try {
                getAttributeInt = IServerAttributes.class.getDeclaredMethod("getAttribute", String.class, Integer.TYPE);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noPublicAPIForGetSetAttribute = true;
            }
        }
        if (noPublicAPIForGetSetAttribute) {
            if (attrs instanceof ServerWorkingCopy) {
                return ((ServerWorkingCopy)attrs).getAttribute(name, defaultValue);
            }
            if (attrs instanceof Server) {
                return ((Server)attrs).getAttribute(name, defaultValue);
            }
            return -1;
        }
        try {
            return (Integer)getAttributeInt.invoke((Object)attrs, name, defaultValue);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return -1;
        }
    }

    public static String getFirstAttribute(IServerAttributes attrs, String defaultValue, String ... names) {
        int i = 0;
        while (i < names.length) {
            String val = ServerHelper.getAttribute(attrs, names[i], defaultValue);
            if (val != null) {
                return val;
            }
            ++i;
        }
        return defaultValue;
    }

    public static String getAttribute(IServerAttributes attrs, String name, String defaultValue) {
        if (getAttributeString == null) {
            try {
                getAttributeString = IServerAttributes.class.getDeclaredMethod("getAttribute", String.class, String.class);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noPublicAPIForGetSetAttribute = true;
            }
        }
        if (noPublicAPIForGetSetAttribute) {
            if (attrs instanceof ServerWorkingCopy) {
                return ((ServerWorkingCopy)attrs).getAttribute(name, defaultValue);
            }
            if (attrs instanceof Server) {
                return ((Server)attrs).getAttribute(name, defaultValue);
            }
            return null;
        }
        try {
            return (String)getAttributeString.invoke((Object)attrs, name, defaultValue);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getAttribute(IServerAttributes attrs, String name, Map<String, String> defaultValue) {
        log.trace("getAttribute. attrs: " + attrs + " name: " + name + " defaultValue: " + defaultValue + " noPublicAPIForGetSetAttribute: " + noPublicAPIForGetSetAttribute);
        if (getAttributeMap == null) {
            try {
                getAttributeMap = IServerAttributes.class.getDeclaredMethod("getAttribute", String.class, Map.class);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noPublicAPIForGetSetAttribute = true;
            }
        }
        if (noPublicAPIForGetSetAttribute) {
            if (attrs instanceof ServerWorkingCopy) {
                return ((ServerWorkingCopy)attrs).getAttribute(name, defaultValue);
            }
            if (attrs instanceof Server) {
                return ((Server)attrs).getAttribute(name, defaultValue);
            }
            return null;
        }
        try {
            return (Map)getAttributeMap.invoke((Object)attrs, name, defaultValue);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static void inspectserver(IServer server) {
        try {
            log.info("inspectserver. server: " + server);
            log.info("attrs class " + server.getClass().getName());
            ServerHelper.inspectserverAttribute(server, "id");
            ServerHelper.inspectserverAttribute(server, "id-set");
            ServerHelper.inspectserverAttribute(server, "server-type-id");
            ServerHelper.inspectserverAttribute(server, "hostname");
            ServerHelper.inspectserverAttribute(server, "start-timeout");
            ServerHelper.inspectserverAttribute(server, "stop-timeout");
            ServerHelper.inspectserverAttribute(server, "name");
            ServerHelper.inspectserverAttribute(server, "profile-dir");
            ServerHelper.inspectserverAttribute(server, "profile-name");
            ServerHelper.inspectserverAttribute(server, "cell-name");
            ServerHelper.inspectserverAttribute(server, "node-name");
            ServerHelper.inspectserverAttribute(server, "server-name");
            ServerHelper.inspectserverAttribute(server, "serverName");
            ServerHelper.inspectserverAttribute(server, "SERVER_NAME");
            ServerHelper.inspectserverAttribute(server, "server-location");
            ServerHelper.inspectserverAttribute(server, "DOMAIN_DIRECTORY");
            ServerHelper.inspectAttributesMap(server);
            ServerHelper.inspectModules(server.getModules());
            log.info("");
            log.info("");
            log.info("");
        }
        catch (Throwable e) {
            log.info("Failed to inspect server - " + e.toString());
        }
    }

    private static void inspectAttributesMap(IServer server) {
        Field[] fields = Server.class.getSuperclass().getDeclaredFields();
        log.info("get data from Server superclass");
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("map")) {
                Field mapField = field;
                field.setAccessible(true);
                try {
                    Map value = (Map)mapField.get(server);
                    log.info("map value " + value.toString());
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    private static void inspectModules(IModule[] modules) {
        if (modules == null) {
            return;
        }
        log.info("modules length " + modules.length);
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule mod = iModuleArray[n2];
            log.info("module " + mod);
            ++n2;
        }
    }

    private static void inspectserverAttribute(IServer attrs, String name) {
        Object val = null;
        if (attrs instanceof Base) {
            String retString;
            int ret;
            List list;
            Base base = (Base)attrs;
            Map map = base.getAttribute(name, null);
            if (map != null) {
                val = map;
            }
            if ((list = base.getAttribute(name, null)) != null) {
                val = list;
            }
            if ((ret = base.getAttribute(name, -123777)) != -123777) {
                val = ret;
            }
            if (!"-123777".equals(retString = base.getAttribute(name, "-123777"))) {
                val = retString;
            }
            if (base.isAttributeSet(name) || val != null) {
                log.trace("inspectserverAttribute. name: " + name + " isSet: " + base.isAttributeSet(name) + " val: " + val);
            }
        }
    }

    public static void setAttribute(IServerWorkingCopy workingCopy, String name, int value) {
        if (setAttributeInt == null) {
            try {
                setAttributeInt = IServerWorkingCopy.class.getDeclaredMethod("setAttribute", String.class, Integer.TYPE);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noPublicAPIForGetSetAttribute = true;
            }
        }
        if (noPublicAPIForGetSetAttribute) {
            if (workingCopy instanceof ServerWorkingCopy) {
                ((ServerWorkingCopy)workingCopy).setAttribute(name, value);
            }
        } else {
            try {
                setAttributeInt.invoke((Object)workingCopy, name, value);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void removeAttribute(IServerWorkingCopy workingCopy, String name) {
        if (setAttributeString == null) {
            try {
                setAttributeString = IServerWorkingCopy.class.getDeclaredMethod("setAttribute", String.class, String.class);
            }
            catch (SecurityException e) {
                log.error((Throwable)e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noPublicAPIForGetSetAttribute = true;
            }
        }
        if (noPublicAPIForGetSetAttribute) {
            if (workingCopy instanceof ServerWorkingCopy) {
                ((ServerWorkingCopy)workingCopy).setAttribute(name, null);
            }
        } else {
            try {
                setAttributeString.invoke((Object)workingCopy, name, null);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }
}

