/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.config.servers;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.eclipse.launching.IRebelLaunchable;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.eclipse.wtp.ui.config.WTPServerLaunchablesProvider;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ServerLifecycleListener
implements IServerLifecycleListener {
    private static final Log log = Log.getInstance(ServerLifecycleListener.class);
    private static final Executor executor = Executors.newSingleThreadExecutor();

    public void serverAdded(final IServer server) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                log.info("ServerLifecycleListener.serverAdded. " + server);
                try {
                    Thread.sleep(100L);
                    IRebelLaunchable adapter = ServerLifecycleListener.this.getAdapter(server);
                    log.info("adapter " + adapter);
                    if (adapter != null) {
                        this.trySetJRebelEnabled(server, (IRebelLaunchable<IServer, IServerWorkingCopy>)adapter);
                    }
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }

            private void trySetJRebelEnabled(IServer server2, IRebelLaunchable<IServer, IServerWorkingCopy> adapter) {
                try {
                    ServerLaunchables.bind(server2, (IRebelServer)adapter).setJRebelEnabled(true);
                }
                catch (CoreException e) {
                    log.info("got exception while enabling JRebel " + e.toString());
                }
            }
        });
    }

    private IRebelLaunchable<IServer, IServerWorkingCopy> getAdapter(IServer server) {
        return new WTPServerLaunchablesProvider().getAdapter(server);
    }

    public void serverChanged(IServer server) {
        log.info("ServerLifecycleListener.serverChanged. " + server);
    }

    public void serverRemoved(IServer server) {
        log.info("ServerLifecycleListener.serverRemoved. " + server);
    }
}

