/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.glassfish;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.zeroturnaround.common.args.store.GlassFishXmlArgStore;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.ui.tabs.JRebelTab;
import org.zeroturnaround.eclipse.wtp.containers.glassfish.GlassfishUtil;
import org.zeroturnaround.jrebel.client.logger.Log;

public class GlassfishRebelTab
extends JRebelTab {
    private static final Log log = Log.getInstance(GlassfishRebelTab.class);
    private boolean bypassRealPerformApply;

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        log.info(" -- performApply() called  for Glassfish rebel-tab ");
        if (this.bypassRealPerformApply) {
            GlassfishUtil.setValuesToConfig(config, this.fLaunchRebelButton.getSelection());
        } else {
            log.info(" -- commiting to file system!!");
            try {
                GlassfishUtil.commitChangesToFileSystem(config);
                this.refreshArgumentsTab(config);
            }
            catch (CoreException ce) {
                log.error((Throwable)ce);
            }
        }
        this.bypassRealPerformApply = false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.bypassRealPerformApply = true;
        log.info(" ===== initializeFrom [GLASSFISH]");
        try {
            ILaunchConfigurationWorkingCopy launchConf = configuration.getWorkingCopy();
            if (GlassfishUtil.isInitializableFrom((ILaunchConfiguration)launchConf)) {
                File domainXml = GlassfishUtil.getDomainXmlFile((ILaunchConfiguration)launchConf);
                GlassFishXmlArgStore argStore = new GlassFishXmlArgStore(domainXml);
                this.fLaunchRebelButton.setSelection(JRebel.getDefault().isEnabledIn((IArgStore)argStore));
            }
        }
        catch (CoreException e) {
            log.error((Throwable)e);
        }
    }

    protected void rebelCheckboxChanged() {
        this.processCheckboxUpdate();
    }

    private void processCheckboxUpdate() {
        log.info(" -- just making the workingCopy dirty");
        this.bypassRealPerformApply = true;
        this.updateLaunchConfigurationDialog();
    }
}

