/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.glassfish;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.internal.Server;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.GlassFishXmlArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.jrebel.args.EclipseLaunchingArgs;
import org.zeroturnaround.eclipse.launching.support.JVMHelper;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.logger.Log;

public class GlassfishUtil {
    private static final Log log = Log.getInstance(GlassfishUtil.class);
    private static final String JREBEL_ENABLED = "JRebel.isEnabled";
    private static final String DOMAIN_PATH = "sunappserver.domainpath";
    private static final String DOMAIN_DIR = "sunappserver.domaindir";
    private static final String DOMAIN_NAME = "sunappserver.domainname";
    private static final String DOMAIN_PATH_LUNA = "glassfish.domainpath";
    private static final String DOMAIN_DIR_LUNA = "glassfish.domaindir";
    private static final String DOMAIN_NAME_LUNA = "glassfish.domainname";
    private static final String DOMAIN_NAME_MYECLIPSE = "SUN_DOMAIN_NAME";

    private GlassfishUtil() {
    }

    public static ArgChanges enableOrDisableJRebel(ILaunchConfiguration config, boolean enable) {
        try {
            if (enable) {
                IVMInstall vmInstall = JavaRuntime.computeVMInstall((ILaunchConfiguration)config);
                return EclipseLaunchingArgs.getJVMArgAdditions((JavaVM)JVMHelper.getJavaVM((IVMInstall)vmInstall), null);
            }
            return EclipseLaunchingArgs.getJVMArgRemovals();
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return new ArgChanges();
        }
    }

    public static ArgChanges enableOrDisableLogging(GlassFishXmlArgStore store, boolean enable) {
        ArgChanges changes = new ArgChanges();
        if (enable) {
            changes.add((IArgument)RebelArgs.rebelLogDebug());
        } else {
            changes.remove((IArgument)RebelArgs.rebelLogDebug());
        }
        return changes;
    }

    public static void commitChangesToFileSystem(ILaunchConfigurationWorkingCopy config) throws CoreException {
        if (!GlassfishUtil.isInitializableFrom((ILaunchConfiguration)config)) {
            return;
        }
        GlassFishXmlArgStore store = new GlassFishXmlArgStore(GlassfishUtil.getDomainXmlFile((ILaunchConfiguration)config));
        ArgChanges changes = GlassfishUtil.enableOrDisableJRebel((ILaunchConfiguration)config, GlassfishUtil.isRebelEnabled(config));
        store.apply(changes);
    }

    public static boolean isRebelEnabled(ILaunchConfigurationWorkingCopy config) throws CoreException {
        return config.getAttribute(JREBEL_ENABLED, false);
    }

    public static void setValuesToConfig(ILaunchConfigurationWorkingCopy config, boolean rebelEnabled) {
        config.setAttribute(JREBEL_ENABLED, rebelEnabled);
    }

    public static File getDomainXmlFile(ILaunchConfiguration config) throws CoreException {
        IServer iServer = ServerLaunchables.getServer(config);
        Server server = (Server)iServer;
        return GlassfishUtil.getDomainXmlFile((IServer)server);
    }

    protected static boolean isInitializableFrom(ILaunchConfiguration config) throws CoreException {
        return config.getAttributes().containsKey("server-id");
    }

    public static File getDomainXmlFile(IServer iServer) throws CoreException {
        Map<String, String> properties = ServerHelper.getAttribute((IServerAttributes)iServer, "generic_server_instance_properties", new HashMap<String, String>());
        Server server = (Server)iServer;
        Object domainPath = properties.get(DOMAIN_PATH) != null ? new Path(properties.get(DOMAIN_PATH)) : (properties.get(DOMAIN_DIR) != null && properties.get(DOMAIN_NAME) != null ? new Path(properties.get(DOMAIN_DIR)).append(properties.get(DOMAIN_NAME)) : (server.getAttribute(DOMAIN_PATH_LUNA, null) != null ? new Path(server.getAttribute(DOMAIN_PATH_LUNA, null)) : (server.getAttribute(DOMAIN_DIR_LUNA, null) != null && server.getAttribute(DOMAIN_NAME_LUNA, null) != null ? new Path(server.getAttribute(DOMAIN_DIR_LUNA, null)).append(server.getAttribute(DOMAIN_NAME_LUNA, null)) : new Path(server.getAttribute("server-location", null)).append("domains").append(server.getAttribute(DOMAIN_NAME_MYECLIPSE, null)))));
        String fullPath = domainPath.append("config").append("domain.xml").toOSString();
        log.info("-- Found domain.xml full path to be : " + fullPath);
        return new File(fullPath);
    }
}

