/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.wasliberty;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.jrebel.client.logger.Log;

public class WASLibertyUtil {
    private static final Log log = Log.getInstance(WASLibertyUtil.class);
    private static final String JVM_OPTIONS_FILE = "jvm.options";
    private static final String ATTR_SERVER_NAME = "serverName";
    private static final String ATTR_SERVER_NAME_MYECLIPSE = "SERVER_NAME";

    public static IPath getServerPath(IServer server) {
        String serverName = WASLibertyUtil.getServerName(server);
        IPath installLoc = server.getRuntime().getLocation();
        IPath path = installLoc.append("usr").append("servers").append(serverName);
        log.trace("getServerPath. path: " + path);
        return path;
    }

    public static File getJVMOptionsFile(IServer server) {
        IPath serverPath = WASLibertyUtil.getServerPath(server);
        return serverPath.append(JVM_OPTIONS_FILE).toFile();
    }

    private static String getServerName(IServer server) {
        String ret = ServerHelper.getAttribute((IServerAttributes)server, ATTR_SERVER_NAME, null);
        if (ret == null) {
            ret = ServerHelper.getAttribute((IServerAttributes)server, ATTR_SERVER_NAME_MYECLIPSE, null);
        }
        return ret;
    }
}

