/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.containers.weblogic;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.server.weblogic.WLSVariables;
import org.zeroturnaround.common.util.EnvironmentUtil;
import org.zeroturnaround.eclipse.launching.launchconfig.EnvVarDynArgsRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.eclipse.wtp.launching.launchconfig.ServerBasedRebelLaunchConfig;
import org.zeroturnaround.jrebel.client.logger.ConsoleLog;
import org.zeroturnaround.jrebel.client.logger.Log;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

public class WebLogicRebelLaunchConfig
extends EnvVarDynArgsRebelLaunchConfig {
    private static final Log log = Log.getInstance(WebLogicRebelLaunchConfig.class);
    private static final ConsoleLog consoleLog = ConsoleLog.getInstance(WebLogicRebelLaunchConfig.class);
    private static final String ATTR_WEBLOGIC_DOMAIN_PATH = "weblogic_domain_path";
    private static final String ATTR_WEBLOGIC_DOMAIN_PATH_MYECLIPSE = "DOMAIN_DIRECTORY";
    private static final String JAVA_OPTIONS = "JAVA_OPTIONS";

    public WebLogicRebelLaunchConfig() {
        super(JAVA_OPTIONS, EnvironmentUtil.isWindows());
    }

    public JavaVM getJVM(ILaunchConfiguration config) throws CoreException {
        try {
            IServer server = ServerLaunchables.getServer(config);
            if (server != null) {
                IPath installLocation = server.getRuntime().getLocation();
                String domainPath = ServerHelper.getFirstAttribute((IServerAttributes)server, null, ATTR_WEBLOGIC_DOMAIN_PATH, ATTR_WEBLOGIC_DOMAIN_PATH_MYECLIPSE);
                log.info("getJVM() domainPath=" + domainPath);
                if (installLocation != null && domainPath != null) {
                    File tmpDir = JRebelClientAdapter.getInstance().getClientSettings().getIdeTempFolder();
                    WLSVariables wls = new WLSVariables(Maybe.some((Object)installLocation.toFile()), new File(domainPath), tmpDir);
                    Maybe javaHome = wls.getJavaHome();
                    if (javaHome.isDefined()) {
                        log.info("getJVM() javaHome=" + (String)javaHome.get());
                        return JavaVM.getJavaJVM((String)((String)javaHome.get()));
                    }
                }
                if (domainPath == null) {
                    ServerHelper.inspectserver(server);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return super.getJVM(config);
    }

    public void setJRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        super.setJRebelEnabled(workingCopy, enable);
        if (enable) {
            this.disableWeblogicJavaOptionsOverwrite((ILaunchConfiguration)workingCopy);
        }
    }

    public void updateIfNecessary(ILaunchConfiguration config) throws CoreException {
        super.updateIfNecessary(config);
        if (this.isJRebelEnabled(config)) {
            this.disableWeblogicJavaOptionsOverwrite(config);
        }
    }

    private void disableWeblogicJavaOptionsOverwrite(ILaunchConfiguration config) throws CoreException {
        String key = "start_as_wlx";
        IServer server = ServerLaunchables.getServer(config);
        if (server.getAttribute(key, false)) {
            IServerWorkingCopy swc = ServerBasedRebelLaunchConfig.getServerWorkingCopy(config);
            swc.setAttribute(key, false);
            swc.save(true, (IProgressMonitor)new NullProgressMonitor());
            consoleLog.warn("Disabling Express Mode for server '{}' due to compatibility reasons.", (Object)server.getId());
        }
    }
}

