/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.jrebel.ide.common.notifications.Area;
import org.zeroturnaround.jrebel.ide.common.notifications.Level;
import org.zeroturnaround.jrebel.ide.common.notifications.MessageProducer;
import org.zeroturnaround.jrebel.ide.common.notifications.Repeat;
import org.zeroturnaround.jrebel.ide.common.notifications.UserNotifications;
import org.zeroturnaround.jrebel.ide.common.notifications.producers.HtmlMessageProducer;

public class AutomaticPublishing {
    private static final String AUTO_PUBLISH_SETTING = "auto-publish-setting";
    private static final String AUTO_PUBLISH_SETTING_OLD = "jrebel.old-auto-publish-setting";
    private static final int AUTO_PUBLISH_NEVER = 1;
    private static final int AUTO_PUBLISH_WHEN_RESOURCES_CHANGE = 2;

    public static boolean updateAutomaticPublishingSetting(IServerWorkingCopy workingCopy, boolean rebelEnabled) throws CoreException {
        return AutomaticPublishing.updateAutomaticPublishingSetting(workingCopy, rebelEnabled, true);
    }

    public static boolean updateAutomaticPublishingSetting(IServerWorkingCopy workingCopy, boolean rebelEnabled, boolean showNotification) {
        int oldSetting;
        if (rebelEnabled) {
            if (ServerHelper.getAttribute((IServerAttributes)workingCopy, AUTO_PUBLISH_SETTING, 2) != 1) {
                int oldSetting2 = ServerHelper.getAttribute((IServerAttributes)workingCopy, AUTO_PUBLISH_SETTING, 2);
                ServerHelper.setAttribute(workingCopy, AUTO_PUBLISH_SETTING_OLD, oldSetting2);
                ServerHelper.setAttribute(workingCopy, AUTO_PUBLISH_SETTING, 1);
                if (showNotification) {
                    AutomaticPublishing.notifyAutoPublishChanged(workingCopy.getName(), false);
                }
                return true;
            }
        } else if (ServerHelper.getAttribute((IServerAttributes)workingCopy, AUTO_PUBLISH_SETTING, 2) == 1 && (oldSetting = ServerHelper.getAttribute((IServerAttributes)workingCopy, AUTO_PUBLISH_SETTING_OLD, -1)) > -1) {
            ServerHelper.setAttribute(workingCopy, AUTO_PUBLISH_SETTING, oldSetting);
            ServerHelper.removeAttribute(workingCopy, AUTO_PUBLISH_SETTING_OLD);
            if (showNotification) {
                AutomaticPublishing.notifyAutoPublishChanged(workingCopy.getName(), true);
            }
            return true;
        }
        return false;
    }

    private static void notifyAutoPublishChanged(String serverName, boolean publishingEnabled) {
        AutomaticPublishing.notifyAutoPublishChanged(Collections.singletonList(serverName), publishingEnabled);
    }

    public static void notifyAutoPublishChanged(List<String> servers, boolean publishingEnabled) {
        if (servers == null || servers.isEmpty()) {
            return;
        }
        HtmlMessageProducer message = AutomaticPublishing.createNotification(servers, publishingEnabled);
        UserNotifications.getInstance().startNotification(Repeat.ONCE, Area.IDE, Level.INFO).setMessage((MessageProducer)message).send();
    }

    static HtmlMessageProducer createNotification(List<String> servers, boolean publishingEnabled) {
        StringBuilder bodyBuilder = new StringBuilder();
        bodyBuilder.append(publishingEnabled ? "Restored" : "Disabled").append(" Automatic Publishing setting for ");
        if (servers.size() == 1) {
            bodyBuilder.append(servers.get(0));
        } else {
            bodyBuilder.append(servers.size()).append(" servers");
        }
        bodyBuilder.append("<br>(JRebel needs Automatic Publishing to be turned off)");
        String title = publishingEnabled ? "Automatic Publishing restored" : "Automatic Publishing disabled";
        return new HtmlMessageProducer(title, bodyBuilder.toString());
    }
}

