/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import java.util.Map;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.VMArgsDynArgsRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.containers.glassfish.GlassFishRebelServer;
import org.zeroturnaround.eclipse.wtp.containers.wasliberty.WASLibertyRebelServer;
import org.zeroturnaround.eclipse.wtp.containers.weblogic.WebLogicRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServerProvider;
import org.zeroturnaround.eclipse.wtp.launching.LaunchConfigBasedRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.RebelServerProviders;
import org.zeroturnaround.jrebel.client.logger.Log;

public class DefaultRebelServerProvider
implements IRebelServerProvider {
    private static final Log log = Log.getInstance(DefaultRebelServerProvider.class);
    protected static final String[] STD_ADAPTOR_SERVER_IDS = new String[]{"org.eclipse.jst.*", "org.mortbay.jetty.*", "org.jboss.ide.eclipse.as.*", "com.vmware.server.tc.*", "com.pivotal.server.tc.*", "com.springsource.tcserver.*", "com.liferay.ide.eclipse.server.tomcat.*", "com.liferay.ide.server.portal", "com.liferay.studio.eclipse.server.ee.*", "com.genuitec.waslp.core.server.*", "com.google.cloud.tools.eclipse.appengine.standard.*", "com.genuitec.embedded.tomcat.server.*", "com.genuitec.tomee.server.*", "com.genuitec.glassfish.server.*", "com.genuitec.jetty.core.server.*", "com.genuitec.jboss.core.server.*", "com.genuitec.wildfly.core.server.*", "com.genuitec.oracle.core.server.*", "com.genuitec.resin.core.server.*", "com.genuitec.weblogic.core.server.*", "com.ibm.etools.wdt.server.*"};
    protected static final String[] WEBLOGIC_ADAPTOR_SERVER_IDS = new String[]{"com.bea.wlw.*", "com.bea.weblogic1*", "weblogic.server"};
    protected static final String[] GLASSFISH_ADAPTOR_SERVER_IDS = new String[]{"com.sun.enterprise.jst.server.*", "org.glassfish.jst.server.*", "glassfish.server", "payara.server"};
    protected static final String[] WAS_LIBERTY_ADAPTOR_SERVER_IDS = new String[]{"com.ibm.ws.st.server.*"};

    @Override
    public IRebelServer createRebelServer(IServer server) {
        return this.createRebelServer(server, null);
    }

    @Override
    public IRebelServer createRebelServer(IServer server, Map cookies) {
        try {
            if (RebelServerProviders.typeIdMatches(server, STD_ADAPTOR_SERVER_IDS)) {
                return new LaunchConfigBasedRebelServer((IRebelLaunchConfig)new VMArgsDynArgsRebelLaunchConfig());
            }
            if (RebelServerProviders.typeIdMatches(server, WEBLOGIC_ADAPTOR_SERVER_IDS)) {
                return new LaunchConfigBasedRebelServer((IRebelLaunchConfig)new WebLogicRebelLaunchConfig());
            }
            if (RebelServerProviders.typeIdMatches(server, GLASSFISH_ADAPTOR_SERVER_IDS)) {
                return new GlassFishRebelServer();
            }
            if (RebelServerProviders.typeIdMatches(server, WAS_LIBERTY_ADAPTOR_SERVER_IDS)) {
                return new WASLibertyRebelServer();
            }
        }
        catch (RuntimeException e) {
            log.error((Throwable)e);
        }
        this.logUnknownServerType(server);
        return null;
    }

    private void logUnknownServerType(IServer server) {
        StringBuilder sb = new StringBuilder("Unknown server type. ");
        sb.append("server=").append(server);
        if (server != null) {
            IServerType type = server.getServerType();
            sb.append("; type=").append(type);
            if (type != null) {
                sb.append("; typeID=").append(type.getId()).append("; typeName=").append(type.getName());
            }
        }
        log.info(sb.toString());
    }
}

