/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.jrebel.client.logger.Log;

public class LaunchConfigBasedRebelServer
implements IRebelServer {
    private static final Log log = Log.getInstance(LaunchConfigBasedRebelServer.class);
    public final IRebelLaunchConfig underlying;

    public LaunchConfigBasedRebelServer(IRebelLaunchConfig underlying) {
        this.underlying = underlying;
    }

    public ITransientArgStore<ILaunchConfigurationWorkingCopy> getArgStore(IServer server, IServerWorkingCopy workingCopy) throws CoreException {
        log.info("LaunchConfigBasedRebelServer.getArgStore. server: " + server + " workingCopy: " + workingCopy);
        return this.underlying.getArgStore(this.getLaunchConfig(server), null);
    }

    public boolean isJRebelEnabled(IServer server) {
        try {
            return this.underlying.isJRebelEnabled((Object)this.getLaunchConfig(server));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public void setJRebelEnabled(IServerWorkingCopy workingCopy, boolean enable) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigWorkingCopy(workingCopy);
        this.underlying.setJRebelEnabled((Object)wc, enable);
        wc.doSave();
    }

    public boolean isXRebelEnabled(IServer server) {
        try {
            return this.underlying.isXRebelEnabled((Object)this.getLaunchConfig(server));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public void setXRebelEnabled(IServerWorkingCopy workingCopy, boolean enable) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigWorkingCopy(workingCopy);
        this.underlying.setXRebelEnabled((Object)wc, enable);
        wc.doSave();
    }

    public JavaVM getJVM(IServer server) throws CoreException {
        return this.underlying.getJVM((Object)this.getLaunchConfig(server));
    }

    public ILaunchConfiguration getLaunchConfig(IServer server) throws CoreException {
        ILaunchConfiguration config = ServerLaunchables.getCachedLaunchConfig(server);
        if (config != null) {
            return config;
        }
        return server.getLaunchConfiguration(true, null);
    }

    public ILaunchConfigurationWorkingCopy getLaunchConfigWorkingCopy(IServerWorkingCopy workingCopy) throws CoreException {
        IServer server = workingCopy instanceof IServer ? (IServer)workingCopy : workingCopy.getOriginal();
        return this.getLaunchConfig(server).getWorkingCopy();
    }
}

