/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.XRebel;
import org.zeroturnaround.eclipse.jrebel.args.EclipseLaunchingArgs;
import org.zeroturnaround.eclipse.launching.support.JVMHelper;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.jrebel.client.logger.Log;

public abstract class RebelServer
implements IRebelServer {
    private static final Log log = Log.getInstance(RebelServer.class);

    public abstract IPersistentArgStore getArgStore(IServer var1, IServerWorkingCopy var2) throws CoreException;

    public boolean isJRebelEnabled(IServer server) {
        try {
            return JRebel.getDefault().isEnabledIn((IArgStore)this.getArgStore(server, null));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public void setJRebelEnabled(IServerWorkingCopy workingCopy, boolean enable) throws CoreException {
        log.info("RebelServer.setJRebelEnabled. workingCopy: " + workingCopy + " enable: " + enable);
        IServer server = workingCopy.getOriginal();
        IPersistentArgStore argStore = this.getArgStore(server, workingCopy);
        ArgChanges changes = null;
        if (enable) {
            JavaVM vm = this.getJVM(server);
            changes = EclipseLaunchingArgs.getJVMArgAdditions((JavaVM)vm, null);
            this.modifyArgumentsOnJRebelEnabledChange(server, changes, enable, vm);
        } else {
            changes = EclipseLaunchingArgs.getJVMArgRemovals();
        }
        argStore.apply(changes);
    }

    public boolean isXRebelEnabled(IServer server) {
        try {
            return XRebel.getDefault().isEnabledIn((IArgStore)this.getArgStore(server, null));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public void setXRebelEnabled(IServerWorkingCopy workingCopy, boolean enable) throws CoreException {
        log.info("RebelServer.setXRebelEnabled. workingCopy: " + workingCopy + " enable: " + enable);
        if (enable) {
            IServer server = workingCopy.getOriginal();
            IPersistentArgStore argStore = this.getArgStore(server, workingCopy);
            argStore.apply(EclipseLaunchingArgs.getXRebelJVMArgAdditions());
        }
    }

    protected void modifyArgumentsOnJRebelEnabledChange(IServer server, ArgChanges changes, boolean enable, JavaVM vm) {
    }

    public JavaVM getJVM(IServer server) throws CoreException {
        ILaunchConfiguration launchConfig = server.getLaunchConfiguration(false, null);
        IVMInstall vmInstall = launchConfig != null ? JavaRuntime.computeVMInstall((ILaunchConfiguration)launchConfig) : JavaRuntime.getDefaultVMInstall();
        return JVMHelper.getJavaVM((IVMInstall)vmInstall);
    }
}

