/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import java.util.List;
import java.util.Map;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.zeroturnaround.eclipse.Hooks;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServerProvider;

public class RebelServerProviders {
    public static final String EXT_ID = "org.zeroturnaround.eclipse.wtp.rebelServerAdaptor";

    public static IRebelServer createRebelServer(IServer server) {
        return RebelServerProviders.createRebelServer(server, null);
    }

    public static IRebelServer createRebelServer(IServer server, Map cookies) {
        List providers = Hooks.getHookList(IRebelServerProvider.class, (String)EXT_ID);
        for (IRebelServerProvider provider : providers) {
            IRebelServer adaptor = provider.createRebelServer(server, cookies);
            if (adaptor == null) continue;
            return adaptor;
        }
        ServerHelper.inspectserver(server);
        return null;
    }

    public static boolean typeIdMatches(IServer server, String[] typeIdPatterns) {
        String[] stringArray = typeIdPatterns;
        int n = typeIdPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String serverTypeId = stringArray[n2];
            if (RebelServerProviders.typeIdMatches(server, serverTypeId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean typeIdMatches(IServer server, String serverTypeIdPattern) {
        IServerType serverType = server.getServerType();
        if (serverType == null || serverType.getId() == null) {
            return false;
        }
        if (serverTypeIdPattern.endsWith("*")) {
            String partialId = serverTypeIdPattern.substring(0, serverTypeIdPattern.length() - 1);
            if (serverType.getId().startsWith(partialId)) {
                return true;
            }
        } else if (serverType.getId().equals(serverTypeIdPattern)) {
            return true;
        }
        return false;
    }
}

