/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerType;
import org.zeroturnaround.eclipse.wtp.launching.BoundRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ServerLaunchables {
    private static final Log log = Log.getInstance(ServerLaunchables.class);
    private static final String ATTR_SERVER_ID = "server-id";
    private static final String ATTR_STOP_SERVER = "stop-server";
    private static final String ATTR_JBDS_LAUNCHING_TYPE = "org.eclipse.jdt.launching.MAIN_TYPE";

    public static IServer getServer(ILaunchConfiguration config) {
        try {
            String serverId = config.getAttribute(ATTR_SERVER_ID, null);
            IServer s = serverId != null ? ServerCore.findServer((String)serverId) : null;
            log.info("getServer() serverId='{}', server: '{}'", (Object)serverId, (Object)s);
            return s;
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static boolean isStopServerLaunch(ILaunchConfiguration configuration) {
        log.trace("isStopServerLaunch");
        try {
            return "true".equals(configuration.getAttribute(ATTR_STOP_SERVER, null)) || "org.jboss.Shutdown".equals(configuration.getAttribute(ATTR_JBDS_LAUNCHING_TYPE, null));
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public static BoundRebelServer bind(IServer server, IRebelServer adaptor) {
        return new BoundRebelServer(server, adaptor);
    }

    public static ILaunchConfiguration getCachedLaunchConfig(IServer server) throws CoreException {
        IServerType serverType = server.getServerType();
        if (serverType == null) {
            return null;
        }
        ILaunchConfigurationType launchConfigType = ((ServerType)serverType).getLaunchConfigurationType();
        if (launchConfigType == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigs = launchManager.getLaunchConfigurations(launchConfigType);
        String id = server.getId();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigs;
        int n = launchConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
            if (id.equals(launchConfig.getAttribute(ATTR_SERVER_ID, ""))) {
                return launchConfig;
            }
            ++n2;
        }
        return null;
    }
}

