/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching.launchconfig;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfigProviderCookies;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.LaunchConfigBasedRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.RebelServerProviders;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.eclipse.wtp.launching.launchconfig.ServerBasedRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.launching.launchconfig.ServerRebelLaunchConfigDecorator;
import org.zeroturnaround.jrebel.client.logger.Log;

public class RebelServerLaunchConfigProvider
implements IRebelLaunchConfigProviderCookies {
    private static final Log log = Log.getInstance(RebelServerLaunchConfigProvider.class);

    public IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config) {
        log.trace("RebelServerLaunchConfigProvider.createRebelLaunchConfig. config: " + config);
        return this.createRebelLaunchConfig(config, null);
    }

    public IRebelLaunchConfig createRebelLaunchConfig(ILaunchConfiguration config, Map cookies) {
        log.trace("RebelServerLaunchConfigProvider.createRebelLaunchConfig. config: " + config + " cookies: " + cookies);
        IServer server = ServerLaunchables.getServer(config);
        if (server != null) {
            IRebelServer adaptor = RebelServerProviders.createRebelServer(server, cookies);
            if (adaptor instanceof LaunchConfigBasedRebelServer && this.isVmServerLaunch(config)) {
                LaunchConfigBasedRebelServer lcServer = (LaunchConfigBasedRebelServer)adaptor;
                return new ServerRebelLaunchConfigDecorator(lcServer.underlying);
            }
            if (adaptor != null) {
                return new ServerBasedRebelLaunchConfig(adaptor);
            }
        }
        return null;
    }

    private boolean isVmServerLaunch(ILaunchConfiguration config) {
        log.trace("isVmServerLaunch");
        try {
            String vmArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            return StringUtils.isNotBlank((CharSequence)vmArgs);
        }
        catch (CoreException e) {
            log.error((Throwable)e);
            return false;
        }
    }

    public boolean shouldDisableJRebel(ILaunch launch) {
        log.trace("shouldDisableJRebel");
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return false;
        }
        if (ServerLaunchables.isStopServerLaunch(config)) {
            IRebelLaunchConfig adaptor = this.createRebelLaunchConfig(config);
            try {
                if (adaptor != null && adaptor.isJRebelEnabled((Object)config) && config.isWorkingCopy()) {
                    adaptor.setJRebelEnabledForWorkingCopyOnly((ILaunchConfigurationWorkingCopy)config, false);
                }
            }
            catch (CoreException e) {
                log.error((Throwable)e);
            }
            return true;
        }
        return false;
    }
}

