/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.launching.launchconfig;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.args.LaunchConfigArgStore;
import org.zeroturnaround.eclipse.launching.launchconfig.IRebelLaunchConfig;
import org.zeroturnaround.eclipse.wtp.config.servers.ServerHelper;
import org.zeroturnaround.eclipse.wtp.containers.glassfish.GlassFishRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.AutomaticPublishing;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.LaunchConfigBasedRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.jrebel.client.logger.Log;

public class ServerBasedRebelLaunchConfig
implements IRebelLaunchConfig {
    private static final Log log = Log.getInstance(ServerBasedRebelLaunchConfig.class);
    private final IRebelServer adaptor;
    private final IRebelLaunchConfig launchConfig;

    public ServerBasedRebelLaunchConfig(IRebelServer adaptor) {
        log.info("ServerBasedRebelLaunchConfig.ServerBasedRebelLaunchConfig. adaptor: {}", (Object)adaptor);
        this.adaptor = adaptor;
        this.launchConfig = ServerBasedRebelLaunchConfig.getRebelLaunchConfig(adaptor);
    }

    private static IRebelLaunchConfig getRebelLaunchConfig(IRebelServer adaptor) {
        if (adaptor instanceof LaunchConfigBasedRebelServer) {
            return ((LaunchConfigBasedRebelServer)adaptor).underlying;
        }
        return null;
    }

    public ITransientArgStore<ILaunchConfigurationWorkingCopy> getArgStore(ILaunchConfiguration config, ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        if (this.launchConfig != null) {
            return this.launchConfig.getArgStore(config, workingCopy);
        }
        return LaunchConfigArgStore.fake((IArgStore)this.adaptor.getArgStore(ServerBasedRebelLaunchConfig.getServer(config), null), (ILaunchConfigurationWorkingCopy)workingCopy);
    }

    public boolean isJRebelEnabled(ILaunchConfiguration config) {
        if (this.launchConfig != null) {
            return this.launchConfig.isJRebelEnabled((Object)config);
        }
        return this.adaptor.isJRebelEnabled(ServerBasedRebelLaunchConfig.getServer(config));
    }

    public void setJRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        IServerWorkingCopy wc = ServerBasedRebelLaunchConfig.getServerWorkingCopy((ILaunchConfiguration)workingCopy);
        if (this.launchConfig != null) {
            this.launchConfig.setJRebelEnabled((Object)workingCopy, enable);
        } else {
            this.adaptor.setJRebelEnabled(wc, enable);
        }
        AutomaticPublishing.updateAutomaticPublishingSetting(wc, enable);
        wc.save(true, null);
    }

    public boolean isXRebelEnabled(ILaunchConfiguration config) {
        if (this.launchConfig != null) {
            return this.launchConfig.isXRebelEnabled((Object)config);
        }
        return this.adaptor.isXRebelEnabled(ServerBasedRebelLaunchConfig.getServer(config));
    }

    public void setXRebelEnabled(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
        IServerWorkingCopy wc = ServerBasedRebelLaunchConfig.getServerWorkingCopy((ILaunchConfiguration)workingCopy);
        if (this.launchConfig != null) {
            this.launchConfig.setXRebelEnabled((Object)workingCopy, enable);
        } else {
            this.adaptor.setXRebelEnabled(wc, enable);
        }
        AutomaticPublishing.updateAutomaticPublishingSetting(wc, enable);
        wc.save(true, null);
    }

    public void setJRebelEnabledForWorkingCopyOnly(ILaunchConfigurationWorkingCopy workingCopy, boolean enable) throws CoreException {
    }

    public JavaVM getJVM(ILaunchConfiguration config) throws CoreException {
        if (this.launchConfig != null) {
            return this.launchConfig.getJVM((Object)config);
        }
        return this.adaptor.getJVM(ServerBasedRebelLaunchConfig.getServer(config));
    }

    public boolean isAskToLaunchWithJRebelAllowed(ILaunchConfiguration config) {
        if (this.isDeployProjectToServerLaunch(config)) {
            return false;
        }
        return ServerHelper.hasJRebelModules(ServerBasedRebelLaunchConfig.getServer(config));
    }

    private boolean isDeployProjectToServerLaunch(ILaunchConfiguration config) {
        if (this.launchConfig == null) {
            return false;
        }
        try {
            List empty = Collections.emptyList();
            String key = LaunchConfiguration.ATTR_MAPPED_RESOURCE_PATHS;
            return !config.getAttribute(key, empty).isEmpty();
        }
        catch (CoreException e) {
            log.debug((Throwable)e);
            return false;
        }
    }

    public void updateIfNecessary(ILaunchConfiguration config) throws CoreException {
        log.info("ServerBasedRebelLaunchConfig.updateIfNecessary. config: {}", (Object)config);
        if (config.isWorkingCopy()) {
            return;
        }
        JRebel jrebel = JRebel.getDefault();
        ITransientArgStore<ILaunchConfigurationWorkingCopy> argStore = this.getArgStore(config, null);
        log.info("got argstore " + argStore);
        if (jrebel.isEnabledIn(argStore)) {
            if (this.adaptor instanceof GlassFishRebelServer) {
                try {
                    ((GlassFishRebelServer)this.adaptor).contextLaunchConfig = config;
                    this.adaptor.setJRebelEnabled(ServerBasedRebelLaunchConfig.getServerWorkingCopy(config), true);
                }
                finally {
                    ((GlassFishRebelServer)this.adaptor).contextLaunchConfig = null;
                }
            } else {
                this.adaptor.setJRebelEnabled(ServerBasedRebelLaunchConfig.getServerWorkingCopy(config), true);
            }
        }
    }

    private static IServer getServer(ILaunchConfiguration config) {
        return ServerLaunchables.getServer(config);
    }

    public static IServerWorkingCopy getServerWorkingCopy(ILaunchConfiguration config) {
        IServer server = ServerBasedRebelLaunchConfig.getServer(config);
        if (server.isWorkingCopy()) {
            return (IServerWorkingCopy)server;
        }
        return server.createWorkingCopy();
    }

    public boolean isJRebelApplicable(ILaunchConfiguration config) {
        return !this.isDeployProjectToServerLaunch(config) && ServerHelper.hasJavaModules(ServerBasedRebelLaunchConfig.getServer(config));
    }
}

