/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.zeroturnaround.eclipse.RebelPlugin;
import org.zeroturnaround.eclipse.jrebel.JRebel;
import org.zeroturnaround.eclipse.jrebel.events.JRebelEnablementChangedEvent;
import org.zeroturnaround.eclipse.jrebel.events.JRebelServiceChangeListener;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.eclipse.wtp.launching.BoundRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;
import org.zeroturnaround.eclipse.wtp.launching.RebelServerProviders;
import org.zeroturnaround.eclipse.wtp.launching.ServerLaunchables;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.logger.Log;

public class JRebelServerEditorSection
extends ServerEditorSection
implements IPropertyChangeListener,
JRebelServiceChangeListener {
    private static final Log log = Log.getInstance(JRebelServerEditorSection.class);
    protected Section section;
    protected Button jrebelEnabled;
    protected Button xrebelEnabled;
    private IEditorSite site;
    private Label noJRebelLabel;
    protected BoundRebelServer rebelServer;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        log.trace("init");
        this.site = site;
        RebelPlugin.getJRebelService().addListener((JRebelServiceChangeListener)this);
    }

    public void dispose() {
        log.debug("JRebelServerEditor disposed: {}", (Object)this);
        RebelPlugin.getJRebelService().removeListener((JRebelServiceChangeListener)this);
        RebelPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected boolean checkAdaptorExists() {
        block3: {
            try {
                if (this.getServer().getLaunchConfiguration(true, null) != null) break block3;
                return false;
            }
            catch (CoreException e) {
                log.error((Throwable)e);
                return false;
            }
        }
        return this.initializeAdaptor() != null;
    }

    protected synchronized BoundRebelServer initializeAdaptor() {
        IServer server;
        IRebelServer adaptor;
        if (this.rebelServer == null && (adaptor = RebelServerProviders.createRebelServer(server = this.getServer())) != null) {
            this.rebelServer = ServerLaunchables.bind(server, adaptor);
        }
        return this.rebelServer;
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        if (!this.checkAdaptorExists()) {
            return;
        }
        FormToolkit formToolkit = this.getFormToolkit(parent.getDisplay());
        this.section = formToolkit.createSection(parent, 458);
        this.section.setText("JRebel Integration");
        this.section.setDescription("JRebel integration");
        this.section.setLayoutData((Object)new GridData(4, 4, false, false));
        Composite composite = formToolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.jrebelEnabled = formToolkit.createButton(composite, "Enable JRebel agent", 32);
        this.jrebelEnabled.addSelectionListener((SelectionListener)new JRebelSelectionListener());
        this.jrebelEnabled.setSelection(this.getJRebelSelectedInitialValue());
        this.xrebelEnabled = formToolkit.createButton(composite, "Enable XRebel agent", 32);
        this.xrebelEnabled.addSelectionListener((SelectionListener)new XRebelSelectionListener());
        this.xrebelEnabled.setSelection(this.getXRebelSelectedInitialValue());
        if (!JRebel.isConfigured()) {
            this.jrebelEnabled.setEnabled(false);
            this.noJRebelLabel = formToolkit.createLabel(composite, "You need to set JRebel location first. This can be done in Window -> Preferences -> JRebel");
            RebelPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        } else {
            Hyperlink metadataLink = formToolkit.createHyperlink(composite, "Open JRebel log file location", 0);
            metadataLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    Program.launch((String)JRebelConfiguration.getDefault().getLogDir());
                }
            });
        }
        formToolkit.createLabel(composite, "Notice: Automatic Publishing will be disabled when JRebel is enabled");
        formToolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (JRebel.isConfigured()) {
            this.jrebelEnabled.setEnabled(true);
            if (this.noJRebelLabel != null) {
                this.noJRebelLabel.dispose();
            }
        }
    }

    protected void enableJRebel(boolean enable) throws CoreException {
        this.rebelServer.setJRebelEnabled(enable);
        RebelPlugin.getJRebelService().fireRebelEnablementChangedEvent((Object)this, (Object)this.getOriginalServer(), enable);
    }

    protected void enableXRebel(boolean enable) throws CoreException {
        this.rebelServer.setXRebelEnabled(enable);
        RebelPlugin.getJRebelService().fireRebelEnablementChangedEvent((Object)this, (Object)this.getOriginalServer(), enable);
    }

    public void rebelEnabledChanged(JRebelEnablementChangedEvent event) {
        IServer server;
        log.trace("rebelEnabledChanged");
        if (event.source == this) {
            return;
        }
        if (this.jrebelEnabled.isDisposed()) {
            log.info("got enablement event, but widget disposed. event: '{}',  listener: '{}'", (Object)event, (Object)this);
            return;
        }
        if (event.launchable instanceof IServer && event.launchable == this.getOriginalServer()) {
            EclipseUtil.runInUiThread(() -> this.jrebelEnabled.setSelection(jRebelEnablementChangedEvent.enabled));
        }
        if (event.launchable instanceof ILaunchConfiguration && (server = ServerLaunchables.getServer((ILaunchConfiguration)event.launchable)) == this.getOriginalServer()) {
            EclipseUtil.runInUiThread(() -> this.jrebelEnabled.setSelection(jRebelEnablementChangedEvent.enabled));
        }
    }

    public void startupConfigurationChangedEvent() {
    }

    protected IServer getServer() {
        ServerEditorPart part = (ServerEditorPart)this.site.getPart();
        return (IServer)part.getServer();
    }

    protected IServer getOriginalServer() {
        IServer serv = this.getServer();
        if (serv.isWorkingCopy()) {
            return ((IServerWorkingCopy)serv).getOriginal();
        }
        return serv;
    }

    protected boolean getJRebelSelectedInitialValue() {
        return this.rebelServer.isJRebelEnabled();
    }

    protected boolean getXRebelSelectedInitialValue() {
        return this.rebelServer.isXRebelEnabled();
    }

    private class JRebelSelectionListener
    extends SelectionAdapter {
        private JRebelSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                boolean enabled = ((Button)e.getSource()).getSelection();
                JRebelServerEditorSection.this.enableJRebel(enabled);
            }
            catch (CoreException ex) {
                ((Button)e.getSource()).setEnabled(!((Button)e.getSource()).getSelection());
                log.error((Throwable)ex);
            }
        }
    }

    private class XRebelSelectionListener
    extends SelectionAdapter {
        private XRebelSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                boolean enabled = ((Button)e.getSource()).getSelection();
                JRebelServerEditorSection.this.enableXRebel(enabled);
            }
            catch (CoreException ex) {
                ((Button)e.getSource()).setEnabled(!((Button)e.getSource()).getSelection());
                log.error((Throwable)ex);
            }
        }
    }
}

