/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.ui.config;

import com.swtdesigner.SWTResourceManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.zeroturnaround.eclipse.config.components.ZTCheckboxTreeViewer;
import org.zeroturnaround.eclipse.config.ui.launchables.ILaunchablesProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.LaunchablesColumnLabelProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.LaunchablesContentProvider;
import org.zeroturnaround.eclipse.config.ui.launchables.RebelLaunchablesTable;
import org.zeroturnaround.eclipse.ui.RebelImage;
import org.zeroturnaround.eclipse.util.EclipseUtil;
import org.zeroturnaround.eclipse.wtp.launching.IRebelServer;

public final class WTPServersTab
extends RebelLaunchablesTable<IServer, IServerWorkingCopy> {
    private final ServerLifecycleListener serverLifecycleListener;

    public WTPServersTab(Composite parent, int style, ILaunchablesProvider<IServer, IServerWorkingCopy> provider) {
        super(parent, style, provider);
        this.serverLifecycleListener = new ServerLifecycleListener(this.treeViewer);
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
    }

    protected void createButtons(Composite buttonsContainer) {
    }

    protected LaunchablesColumnLabelProvider<IServer, IServerWorkingCopy> createMainColumnLabelProvider() {
        return new LaunchablesColumnLabelProvider<IServer, IServerWorkingCopy>(this.provider){

            protected String getNoLaunchablesText() {
                return "Add a new server from the Servers view";
            }
        };
    }

    protected void createMenu(Tree tree) {
        Menu menu = new Menu((Control)tree);
        tree.setMenu(menu);
        final MenuItem mntmOpenServerEditor = new MenuItem(menu, 0);
        mntmOpenServerEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)WTPServersTab.this.treeViewer.getSelection();
                if (sel.getFirstElement() instanceof IServer) {
                    WTPServersTab.this.provider.openLaunchableUI((RebelLaunchablesTable)WTPServersTab.this, (Object)((IServer)sel.getFirstElement()));
                }
            }
        });
        mntmOpenServerEditor.setText("Open");
        final MenuItem mntmJrebelEnabled = new MenuItem(menu, 32);
        mntmJrebelEnabled.setImage(RebelImage.JREBEL.getImage());
        mntmJrebelEnabled.setText("JRebel Enabled");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (sel.getFirstElement() instanceof IServer) {
                        IRebelServer adaptor = (IRebelServer)WTPServersTab.this.getAdapter((IServer)sel.getFirstElement());
                        mntmJrebelEnabled.setSelection(adaptor != null && adaptor.isJRebelEnabled((IServer)sel.getFirstElement()));
                    }
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)WTPServersTab.this.getShell(), (String)"Error enabling JRebel on the server", (String)"An error occured while enabling JRebel on the server");
                }
            }
        });
        mntmJrebelEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)WTPServersTab.this.treeViewer.getSelection();
                if (sel.getFirstElement() instanceof IServer) {
                    IServer server = (IServer)sel.getFirstElement();
                    IRebelServer adaptor = (IRebelServer)WTPServersTab.this.getAdapter(server);
                    if (adaptor == null) {
                        WTPServersTab.this.treeViewer.setChecked((Object)server, false);
                        WTPServersTab.this.checkStateAdapter.checkStateChanged(new CheckStateChangedEvent((ICheckable)WTPServersTab.this.treeViewer, (Object)server, false));
                    } else {
                        boolean newState = !WTPServersTab.this.treeViewer.getChecked((Object)server);
                        WTPServersTab.this.treeViewer.setChecked((Object)server, newState);
                        WTPServersTab.this.checkStateAdapter.checkStateChanged(new CheckStateChangedEvent((ICheckable)WTPServersTab.this.treeViewer, (Object)server, newState));
                    }
                }
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                IStructuredSelection sel = (IStructuredSelection)WTPServersTab.this.treeViewer.getSelection();
                boolean enableMenu = sel.getFirstElement() instanceof IServer;
                mntmJrebelEnabled.setEnabled(enableMenu);
                mntmOpenServerEditor.setEnabled(enableMenu);
            }
        });
    }

    protected void createAdditionalComponents() {
        Label lblAutoPublishing = this.toolkit.createLabel((Composite)this, "Note: Automatic publishing will be disabled when JRebel is enabled.", 0);
        lblAutoPublishing.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblAutoPublishing.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)2));
    }

    public void dispose() {
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifecycleListener);
        super.dispose();
    }

    private static final class ServerLifecycleListener
    implements IServerLifecycleListener {
        private final ZTCheckboxTreeViewer viewer;

        private ServerLifecycleListener(ZTCheckboxTreeViewer viewer) {
            this.viewer = viewer;
        }

        public void serverRemoved(IServer server) {
            if (this.isDisposed()) {
                return;
            }
            EclipseUtil.runInUiThread(() -> this.viewer.setInput(LaunchablesContentProvider.ROOT));
        }

        public void serverChanged(IServer server) {
            if (this.isDisposed()) {
                return;
            }
            EclipseUtil.runInUiThread(() -> this.viewer.update((Object)server, null));
        }

        public void serverAdded(IServer server) {
            if (this.isDisposed()) {
                return;
            }
            EclipseUtil.runInUiThread(() -> this.viewer.setInput(LaunchablesContentProvider.ROOT));
        }

        private boolean isDisposed() {
            Control control = this.viewer.getControl();
            return control == null || control.isDisposed();
        }
    }
}

