/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.ui.config;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.zeroturnaround.eclipse.config.extension.IConfigCenterServersTab;
import org.zeroturnaround.eclipse.config.extension.IConfigCenterServersTabProvider;
import org.zeroturnaround.eclipse.ui.SWTUtil;
import org.zeroturnaround.eclipse.wtp.ui.config.MyEclipseServersTab;
import org.zeroturnaround.eclipse.wtp.ui.config.WTPServerLaunchablesProvider;
import org.zeroturnaround.eclipse.wtp.ui.config.WTPServersTab;

public class WTPServersTabProvider
implements IConfigCenterServersTabProvider {
    private static final boolean IS_MYECLIPSE = Platform.getBundle((String)"com.genuitec.eclipse.easie.core") != null;

    public IConfigCenterServersTab createTab(CTabFolder tabFolder) {
        final CTabItem tbtmWtpServers = new CTabItem(tabFolder, 0);
        if (IS_MYECLIPSE) {
            tbtmWtpServers.setText("MyEclipse Server Connectors");
        } else {
            tbtmWtpServers.setText("Eclipse Java EE Servers");
        }
        final Control tabContent = this.createTabContents((Composite)tabFolder);
        tbtmWtpServers.setControl(tabContent);
        return new IConfigCenterServersTab(){

            public boolean hasAnyServers() {
                return ServerCore.getServers().length > 0;
            }

            public CTabItem getTabItem() {
                return tbtmWtpServers;
            }

            public void dispose() {
                tabContent.dispose();
            }
        };
    }

    public int priority() {
        return 100;
    }

    public Set<File> getKnownContainerRoots() {
        HashSet<File> roots = new HashSet<File>();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            try {
                IPath location = server.getRuntime().getLocation();
                roots.add(location.toFile());
            }
            catch (Exception exception) {}
            ++n2;
        }
        return roots;
    }

    public boolean isEnabled() {
        return true;
    }

    private Control createTabContents(Composite parent) {
        if (IS_MYECLIPSE) {
            return new MyEclipseServersTab(parent, 0);
        }
        WTPServerLaunchablesProvider provider = new WTPServerLaunchablesProvider();
        if (((IServer[])provider.getLaunchables()).length == 0) {
            Label lbl = new Label(parent, 0);
            lbl.setText("\nNo Java EE servers found.\n\n");
            SWTUtil.setFontStyle((Control)lbl, (int)2);
            return lbl;
        }
        return new WTPServersTab(parent, 0, provider);
    }

    public void createControl(Composite parent) {
        this.createTabContents(parent);
    }
}

