/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.eclipse.wtp.ui.earhack;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.zeroturnaround.eclipse.actions.RebelXmlGenerator;
import org.zeroturnaround.eclipse.jrebel.remoting.actions.ToggleRemotingNatureAction;
import org.zeroturnaround.jrebel.client.logger.Log;

public class EarAction
extends ToggleRemotingNatureAction {
    private static final Log log = Log.getInstance(EarAction.class);

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.updateAction(action);
    }

    protected void updateAction(IAction action) {
        IProject project = this.getSelectedProject();
        try {
            if (project != null && project.isOpen() && !project.hasNature("org.eclipse.jdt.core.javanature")) {
                IModule[] modules;
                IModule[] iModuleArray = modules = ServerUtil.getModules((IProject)project);
                int n = modules.length;
                int n2 = 0;
                while (n2 < n) {
                    IModule module = iModuleArray[n2];
                    if ("jst.ear".equals(module.getModuleType().getId())) {
                        action.setEnabled(true);
                        return;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        action.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.updateAction(action);
    }

    protected void toggleNature(IProject project) {
        log.debug("execute EarAction for {}", (Object)project);
        this.printDeploymentInfo(project);
        this.saveDeploymentInfoForSession(project);
        super.toggleNature(project);
    }

    private void printDeploymentInfo(IProject project) {
        log.debug("printDeploymentInfo " + project);
        try {
            IVirtualComponent ivc = ComponentCore.createComponent((IProject)project);
            IVirtualReference[] references = ivc.getReferences();
            log.debug("ref count " + references.length);
            int i = 0;
            while (i < references.length) {
                log.debug(String.valueOf(i) + " = " + references[i].getArchiveName());
                ++i;
            }
            IVirtualComponent[] refComponents = ivc.getReferencingComponents();
            log.debug("refComponents count " + refComponents.length);
            int i2 = 0;
            while (i2 < refComponents.length) {
                log.debug(String.valueOf(i2) + " = " + refComponents[i2]);
                log.debug(String.valueOf(i2) + " = " + refComponents[i2].getDeployedName());
                log.debug(String.valueOf(i2) + " = " + refComponents[i2].getName());
                ++i2;
            }
            StructureEdit structureEdit = StructureEdit.getStructureEditForRead((IProject)project);
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            log.debug("ComponentResource count " + arr.length);
            int i3 = 0;
            while (i3 < arr.length) {
                ComponentResource resource = (ComponentResource)arr[i3];
                log.debug(String.valueOf(i3) + " sourcePath = " + resource.getSourcePath());
                log.debug(String.valueOf(i3) + " = " + resource);
                ++i3;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void saveDeploymentInfoForSession(IProject project) {
        try {
            Method getTagMethod = this.getGetTagMethod();
            log.debug("usesTag " + (getTagMethod != null));
            if (getTagMethod != null) {
                StructureEdit structureEdit = StructureEdit.getStructureEditForRead((IProject)project);
                WorkbenchComponent component = structureEdit.getComponent();
                Object[] arr = component.getResources().toArray();
                int i = 0;
                while (i < arr.length) {
                    ComponentResource resource = (ComponentResource)arr[i];
                    String tag = this.getTag(getTagMethod, resource);
                    log.debug(String.valueOf(i) + " tag = " + tag);
                    if ("defaultRootSource".equals(tag)) {
                        project.setPersistentProperty(RebelXmlGenerator.DEPLOYMENT_PATH_QUALIFIER, resource.getSourcePath().toPortableString());
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            log.info("Got exception while saving deployment info", (Throwable)e);
        }
    }

    private String getTag(Method getTagMethod, ComponentResource resource) {
        try {
            return (String)getTagMethod.invoke((Object)resource, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("Got exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    private Method getGetTagMethod() {
        try {
            return ComponentResource.class.getMethod("getTag", new Class[0]);
        }
        catch (Exception e) {
            log.error("Got exception: {}", (Object)e.getMessage());
            return null;
        }
    }
}

